/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.common;

import co.datadome.api.common.DataDomeEnvironment;
import co.datadome.api.common.DataDomeRequest;
import co.datadome.api.common.DataDomeResolver;
import co.datadome.api.common.DataDomeResponse;
import co.datadome.api.shaded.http.Header;
import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpHost;
import co.datadome.api.shaded.http.NameValuePair;
import co.datadome.api.shaded.http.client.config.RequestConfig;
import co.datadome.api.shaded.http.client.entity.UrlEncodedFormEntity;
import co.datadome.api.shaded.http.client.methods.HttpPost;
import co.datadome.api.shaded.http.config.Registry;
import co.datadome.api.shaded.http.config.RegistryBuilder;
import co.datadome.api.shaded.http.conn.socket.ConnectionSocketFactory;
import co.datadome.api.shaded.http.conn.socket.PlainConnectionSocketFactory;
import co.datadome.api.shaded.http.conn.ssl.SSLConnectionSocketFactory;
import co.datadome.api.shaded.http.impl.client.CloseableHttpClient;
import co.datadome.api.shaded.http.impl.client.DefaultClientConnectionReuseStrategy;
import co.datadome.api.shaded.http.impl.client.HttpClientBuilder;
import co.datadome.api.shaded.http.impl.client.HttpClients;
import co.datadome.api.shaded.http.impl.conn.PoolingHttpClientConnectionManager;
import co.datadome.api.shaded.http.impl.conn.SystemDefaultDnsResolver;
import co.datadome.api.shaded.http.message.BasicNameValuePair;
import co.datadome.api.shaded.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeService {
    private static final Logger logger = Logger.getLogger(DataDomeService.class.getCanonicalName());
    public static final String DEFAULT_API_HOST = "api.datadome.co";
    public static final Boolean DEFAULT_API_SSL = true;
    public static final int DEFAULT_CONNECT_TIMEOUT = 150;
    public static final int DEFAULT_READ_TIMEOUT = 50;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 100;
    public static final String DEFAULT_REGEX = "";
    public static final String DEFAULT_EXCLUSION_REGEX = "(?i)\\.(avi|flv|mka|mkv|mov|mp4|mpeg|mpg|mp3|flac|ogg|ogm|opus|wav|webm|webp|bmp|gif|ico|jpeg|jpg|png|svg|svgz|swf|eot|otf|ttf|woff|woff2|css|less|js)$";
    protected static final String X_DATADOME_RESPONSE_HEADER = "X-DataDomeResponse";
    protected static final String X_DATADOME_REQUEST_HEADERS = "X-DataDome-request-headers";
    protected static final String X_DATADOME_RESPONSE_HEADERS = "X-DataDome-headers";
    private static final int DEFAULT_REFRESH_IN = 300000;
    private final String apiKey;
    private final String apiURL;
    private final RequestConfig requestConfig;
    private final CloseableHttpClient httpClient;
    private static final int URL_ENCODE_CHAR_SIZE = 3;

    public DataDomeService(String apiKey, String apiHost, boolean ssl, String proxyServer, int proxyPort, boolean proxySSL, int connectTimeout, int readTimeout, int maxTotalConnections) throws UnknownHostException {
        this(apiKey, apiHost, ssl, connectTimeout, readTimeout, DataDomeService.buildHttpClient(apiHost, maxTotalConnections, proxyServer, proxyPort, proxySSL));
    }

    protected DataDomeService(String apiKey, String apiHost, boolean ssl, int connectTimeout, int readTimeout, CloseableHttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiURL = (ssl ? "https://" : "http://") + apiHost + "/validate-request/";
        this.httpClient = httpClient;
        this.requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setCookieSpec("ignoreCookies").build();
    }

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSocketFactory())).build();
    }

    private static CloseableHttpClient buildHttpClient(String apiHost, int maxTotalConnections, String proxyServer, int proxyPort, boolean proxySSL) throws UnknownHostException {
        DataDomeResolver dataDomeResolver = new DataDomeResolver(apiHost, proxyServer, 300000, SystemDefaultDnsResolver.INSTANCE);
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(DataDomeService.getDefaultRegistry(), dataDomeResolver);
        poolingHttpClientConnectionManager.setMaxTotal(maxTotalConnections);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(maxTotalConnections);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties().setConnectionReuseStrategy(DefaultClientConnectionReuseStrategy.INSTANCE).setConnectionManager(poolingHttpClientConnectionManager);
        if (proxyServer != null && proxyServer.length() > 0 && proxyPort > 0) {
            httpClientBuilder.setProxy(new HttpHost(proxyServer, proxyPort, proxySSL ? "https" : "http"));
        }
        return httpClientBuilder.build();
    }

    protected static String truncateFromEndStringBaseOnUrlEncodedSize(String s, int limit) {
        int newStart;
        int encodedCharSize;
        if (limit < 0) {
            return s;
        }
        for (int i = newStart = s.length() - 1; i >= 0 && limit != 0 && ((encodedCharSize = DataDomeService.urlEncodedCharSize(s.charAt(i))) != 3 || limit >= 3); limit -= encodedCharSize, --i) {
            --newStart;
        }
        return s.substring(newStart + 1);
    }

    protected static String truncateStringBaseOnUrlEncodedSize(String s, int limit) {
        int encodedCharSize;
        if (limit < 0) {
            return s;
        }
        int newLength = 0;
        for (int i = 0; i < s.length() && limit != 0 && ((encodedCharSize = DataDomeService.urlEncodedCharSize(s.charAt(i))) != 3 || limit >= 3); limit -= encodedCharSize, ++i) {
            ++newLength;
        }
        return s.substring(0, newLength);
    }

    protected static int urlEncodedCharSize(char c) {
        if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '~' || c == ' ') {
            return 1;
        }
        return 3;
    }

    protected static void addParam(List<NameValuePair> postData, String name, String value, int limit, boolean fromEnd) {
        if (value != null) {
            if (fromEnd) {
                postData.add(new BasicNameValuePair(name, DataDomeService.truncateFromEndStringBaseOnUrlEncodedSize(value, limit)));
            } else {
                postData.add(new BasicNameValuePair(name, DataDomeService.truncateStringBaseOnUrlEncodedSize(value, limit)));
            }
        }
    }

    private static List<NameValuePair> buildPostParams(String apiKey, DataDomeRequest request) {
        ArrayList<NameValuePair> postData = new ArrayList<NameValuePair>(45);
        DataDomeService.addParam(postData, "Key", apiKey, -1, false);
        DataDomeService.addParam(postData, "UserAgent", request.getUserAgent(), 768, false);
        DataDomeService.addParam(postData, "IP", request.getIp(), -1, false);
        DataDomeService.addParam(postData, "Port", request.getPort(), -1, false);
        DataDomeService.addParam(postData, "ClientID", request.getClientID(), 128, false);
        DataDomeService.addParam(postData, "Host", request.getHost(), 512, false);
        DataDomeService.addParam(postData, "Referer", request.getReferer(), 1024, false);
        DataDomeService.addParam(postData, "Request", request.getRequest(), 2048, false);
        DataDomeService.addParam(postData, "Protocol", request.getProtocol(), -1, false);
        DataDomeService.addParam(postData, "Method", request.getMethod(), -1, false);
        DataDomeService.addParam(postData, "CookiesLen", request.getCookiesLen(), -1, false);
        DataDomeService.addParam(postData, "TimeRequest", request.getTimeRequest(), -1, false);
        DataDomeService.addParam(postData, "ServerHostname", request.getServerHostname(), 512, false);
        DataDomeService.addParam(postData, "RequestModuleName", DataDomeEnvironment.getModuleName(), -1, false);
        DataDomeService.addParam(postData, "ModuleVersion", DataDomeEnvironment.getModuleVersion(), -1, false);
        DataDomeService.addParam(postData, "PostParamLen", request.getPostParamLen(), -1, false);
        DataDomeService.addParam(postData, "ServerName", DataDomeEnvironment.getServerName(), 512, false);
        DataDomeService.addParam(postData, "XForwardedForIP", request.getxForwardedForIP(), 512, true);
        DataDomeService.addParam(postData, "HeadersList", request.getHeadersList(), 512, false);
        DataDomeService.addParam(postData, "AuthorizationLen", request.getAuthorizationLen(), -1, false);
        DataDomeService.addParam(postData, "X-Requested-With", request.getxRequestedWith(), 128, false);
        DataDomeService.addParam(postData, "Origin", request.getOrigin(), 512, false);
        DataDomeService.addParam(postData, "Connection", request.getConnection(), 128, false);
        DataDomeService.addParam(postData, "Pragma", request.getPragma(), 128, false);
        DataDomeService.addParam(postData, "CacheControl", request.getCacheControl(), 128, false);
        DataDomeService.addParam(postData, "ContentType", request.getContentType(), 64, false);
        DataDomeService.addParam(postData, "From", request.getFrom(), 128, false);
        DataDomeService.addParam(postData, "X-Real-IP", request.getxRealIP(), 128, false);
        DataDomeService.addParam(postData, "Via", request.getVia(), 256, false);
        DataDomeService.addParam(postData, "TrueClientIP", request.getTrueClientIP(), 128, false);
        DataDomeService.addParam(postData, "Accept", request.getAccept(), 512, false);
        DataDomeService.addParam(postData, "AcceptCharset", request.getAcceptCharset(), 128, false);
        DataDomeService.addParam(postData, "AcceptEncoding", request.getAcceptEncoding(), 128, false);
        DataDomeService.addParam(postData, "AcceptLanguage", request.getAcceptLanguage(), 256, false);
        DataDomeService.addParam(postData, "SecCHUA", request.getSecCHUA(), 128, false);
        DataDomeService.addParam(postData, "SecCHUAArch", request.getSecCHUAArch(), 16, false);
        DataDomeService.addParam(postData, "SecCHUAFullVersionList", request.getSecCHUAFullVersionList(), 256, false);
        DataDomeService.addParam(postData, "SecCHUAPlatform", request.getSecCHUAPlatform(), 32, false);
        DataDomeService.addParam(postData, "SecCHUAModel", request.getSecCHUAModel(), 128, false);
        DataDomeService.addParam(postData, "SecCHUAMobile", request.getSecCHUAMobile(), 8, false);
        DataDomeService.addParam(postData, "SecCHDeviceMemory", request.getSecCHDeviceMemory(), 8, false);
        DataDomeService.addParam(postData, "SecFetchDest", request.getSecFetchDest(), 32, false);
        DataDomeService.addParam(postData, "SecFetchMode", request.getSecFetchMode(), 32, false);
        DataDomeService.addParam(postData, "SecFetchSite", request.getSecFetchSite(), 64, false);
        DataDomeService.addParam(postData, "SecFetchUser", request.getSecFetchUser(), 8, false);
        return postData;
    }

    protected HttpPost createHttpPost(DataDomeRequest request) throws IOException {
        HttpPost httpPost = new HttpPost(this.apiURL);
        httpPost.setConfig(this.requestConfig);
        httpPost.setEntity(new UrlEncodedFormEntity(DataDomeService.buildPostParams(this.apiKey, request)));
        if (request.getxSetCookie()) {
            httpPost.setHeader("X-DataDome-X-Set-Cookie", "true");
        }
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDomeResponse validateRequest(DataDomeRequest request) {
        HttpPost httpPost = null;
        long startTime = System.currentTimeMillis();
        Closeable httpResponse = null;
        try {
            httpPost = this.createHttpPost(request);
            httpResponse = this.httpClient.execute(httpPost);
            DataDomeResponse.Builder responseBuilder = DataDomeResponse.builder();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            responseBuilder.setStatusCode(statusCode);
            HttpEntity entity = httpResponse.getEntity();
            String responseBody = DataDomeService.convertStreamToString(entity.getContent());
            EntityUtils.consume(entity);
            responseBuilder.setResponseBody(responseBody);
            if (!DataDomeService.isConfirmedStatus(statusCode, httpResponse.getFirstHeader(X_DATADOME_RESPONSE_HEADER))) {
                logger.log(Level.WARNING, String.format("Invalid response from DataDome: [%.512s]", responseBody));
                DataDomeResponse dataDomeResponse = null;
                return dataDomeResponse;
            }
            Set<String> requestHeaderNames = this.parseDataDomeResponseHeaders(httpResponse.getFirstHeader(X_DATADOME_REQUEST_HEADERS));
            Set<String> responseHeaderNames = this.parseDataDomeResponseHeaders(httpResponse.getFirstHeader(X_DATADOME_RESPONSE_HEADERS));
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                if (requestHeaderNames.contains(header.getName())) {
                    requestHeaders.put(header.getName(), header.getValue());
                }
                if (!responseHeaderNames.contains(header.getName()) && (statusCode != 301 && statusCode != 302 || !header.getName().equals("Location"))) continue;
                responseHeaders.put(header.getName(), header.getValue());
            }
            responseBuilder.setRequestHeaders(requestHeaders);
            responseBuilder.setResponseHeaders(responseHeaders);
            DataDomeResponse dataDomeResponse = responseBuilder.build();
            return dataDomeResponse;
        }
        catch (SocketTimeoutException e) {
            if (httpPost != null) {
                httpPost.abort();
            }
            long timeSpent = System.currentTimeMillis() - startTime;
            logger.log(Level.WARNING, String.format("DataDome time out happened: %s. Spent time (ms): %d", e.getMessage(), timeSpent));
        }
        catch (Throwable e) {
            if (httpPost != null) {
                httpPost.abort();
            }
            long timeSpent = System.currentTimeMillis() - startTime;
            logger.log(Level.SEVERE, String.format("Problem when connecting with DataDome servers: %s. Spent time (ms): %d", e.getMessage(), timeSpent), e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {}
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return null;
    }

    private static String convertStreamToString(InputStream inputStream) {
        if (inputStream == null) {
            return DEFAULT_REGEX;
        }
        Scanner s = new Scanner(inputStream).useDelimiter("\\A");
        return s.hasNext() ? s.next() : DEFAULT_REGEX;
    }

    protected static boolean isConfirmedStatus(int statusCode, Header header) {
        if (header == null) {
            return false;
        }
        try {
            return statusCode == Integer.parseInt(header.getValue());
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Set<String> parseDataDomeResponseHeaders(Header header) {
        if (header == null) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        res.addAll(Arrays.asList(header.getValue().split(" ")));
        return res;
    }
}

