/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.client;

import co.datadome.api.shaded.http.HttpResponse;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.client.ServiceUnavailableRetryStrategy;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

