/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.io;

import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestFactory;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.config.MessageConstraints;
import co.datadome.api.shaded.http.impl.DefaultHttpRequestFactory;
import co.datadome.api.shaded.http.impl.io.DefaultHttpRequestParser;
import co.datadome.api.shaded.http.io.HttpMessageParser;
import co.datadome.api.shaded.http.io.HttpMessageParserFactory;
import co.datadome.api.shaded.http.io.SessionInputBuffer;
import co.datadome.api.shaded.http.message.BasicLineParser;
import co.datadome.api.shaded.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

