package co.datadome.api.common;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public interface HttpRequest {

    void next() throws IOException, ServletException;

    void timeSpent(long elapsedTime);

    void addHeadersInRequest(Set<Map.Entry<String, String>> headers);

    void addHeadersInResponse(Set<Map.Entry<String, String>> headers);

    void block(DataDomeResponse dataDomeResponse) throws IOException;

    String getHeader(String header);

    Collection<String> headers();

    String getIp();

    String getPort();

    String getCookie(String cookieName);

    String uri();

    String query();

    String protocol();

    String method();
}