/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.protocol;

import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestInterceptor;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.params.HttpParams;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

