package co.datadome.api.common;

import java.util.Collection;

public class DataDomeHeaders {
    private DataDomeHeaders() {
        throw new IllegalStateException("Utility class");
    }

    public static final String USER_AGENT_HEADER = "User-Agent";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_TYPE_VALUE = "text/html";
    public static final String REFERER_HEADER = "Referer";
    public static final String TIME_SPENT = "datadome.spent_time";

    public static final String DATADOME_COOKIE = "datadome";
    public static final String COOKIE_HEADER = "Cookie";
    public static final String HOST_HEADER = "Host";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String FORWARDED = "forwarded";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String X_REQUESTED_WITH_HEADER = "X-Requested-With";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String CONNECTION_HEADER = "Connection";
    public static final String PRAGMA_HEADER = "Pragma";
    public static final String CACHE_CONTROL_HEADER = "Cache-Control";
    public static final String FROM_HEADER = "From";
    public static final String X_REAL_IP_HEADER = "X-Real-IP";
    public static final String VIA_HEADER = "Via";
    public static final String TRUE_CLIENT_IP_HEADER = "True-Client-IP";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String X_DATADOME_CLIENTID = "X-DataDome-ClientID";
    public static final String SEC_CH_UA_HEADER = "Sec-CH-UA";
    public static final String SEC_CH_UA_ARCH_HEADER = "Sec-CH-UA-Arch";
    public static final String SEC_CH_UA_FULL_VERSION_LIST_HEADER = "Sec-CH-UA-Full-Version-List";
    public static final String SEC_CH_UA_PLATFORM_HEADER = "Sec-CH-UA-Platform";
    public static final String SEC_CH_UA_MODEL_HEADER = "Sec-CH-UA-Model";
    public static final String SEC_CH_UA_MOBILE_HEADER = "Sec-CH-UA-Mobile";
    public static final String SEC_CH_DEVICE_MEMORY_HEADER = "Sec-CH-Device-Memory";
    public static final String SEC_FETCH_DEST = "Sec-Fetch-Dest";
    public static final String SEC_FETCH_MODE = "Sec-Fetch-Mode";
    public static final String SEC_FETCH_SITE = "Sec-Fetch-Site";
    public static final String SEC_FETCH_USER = "Sec-Fetch-User";

    public static String uriQuery(String uri, String query){
        StringBuilder uriSB = new StringBuilder();
        uriSB.append(uri);
        if (query != null && !query.isEmpty()) {
            uriSB.append("?");
            uriSB.append(query);
        }
        return uriSB.toString();
    }

    public static String headerList(Collection<String> headers){
        // we haven't any guarantee about headers order :(
        StringBuilder sbHeaders = new StringBuilder();
        if (headers != null) {
            for (String name : headers) {
                if (sbHeaders.length() > 0) {
                    sbHeaders.append(",");
                }
                sbHeaders.append(name.toLowerCase());
            }
        }
        return sbHeaders.toString();
    }
}
