package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeEnvironment;
import co.datadome.api.common.DataDomeRequestConsumer;
import co.datadome.api.common.DataDomeService;
import io.vertx.ext.web.RoutingContext;

import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataDomeRouteHandler {

    private static final Logger logger = Logger.getLogger(DataDomeRouteHandler.class.getCanonicalName());

    protected final DataDomeRequestConsumer requestConsumer;

    public DataDomeRouteHandler(DataDomeRouteHandlerConfig config) throws UnknownHostException {
        this.requestConsumer = new DataDomeRequestConsumer(
                new DataDomeService(config.getApiKey(),
                        config.getApiHost(),
                        config.isApiSSL(),
                        config.getProxyServer(),
                        config.getProxyPort(),
                        config.isProxySSL(),
                        config.getConnectTimeout(),
                        config.getReadTimeout(),
                        config.getMaxConnections()),
                config.getRegex(),
                config.getExclusionRegex(),
                config.getExclusionHostRegex(),
                config.getSkipIps(),
                config.isForwardedHost(),
                config.useForwarded());

        DataDomeEnvironment.setServerInfo("vertex-web/" + DataDomeEnvironment.getVertxWebVersion());
    }

    public void handleRequest(RoutingContext routingContext) {
        RoutingContextRequest routingRequest = new RoutingContextRequest(routingContext);

        if (routingContext.request() == null || routingContext.response() == null) {
            logger.log(Level.WARNING, "DataDome: vertex routing has null request or response");
            routingContext.next();
            return;
        }

        try {
            requestConsumer.accept(routingRequest);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "DataDome exception on request validation:", e);
            routingContext.next();
        }
    }


    protected DataDomeRouteHandler(DataDomeRequestConsumer dataDomeRequestConsumer) {
        this.requestConsumer = dataDomeRequestConsumer;
        DataDomeEnvironment.setServerInfo("vertex-web/" + DataDomeEnvironment.getVertxWebVersion());
    }
}
