package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeService;

import java.util.Collections;
import java.util.Set;

@java.lang.SuppressWarnings("squid:S00107")
public class DataDomeRouteHandlerConfig {
    private final String apiKey;
    private final String apiHost;
    private final boolean apiSSL;
    private final String regex;
    private final String exclusionRegex;
    private final String exclusionHostRegex;

    private final int connectTimeout;
    private final int readTimeout;
    private final int maxConnections;
    private final String proxyServer;
    private final int proxyPort;
    private final boolean proxySSL;
    private final boolean useXForwardedHost;
    private final boolean useForwarded;
    private final Set<String> skipIps;

    private DataDomeRouteHandlerConfig(DataDomeRouteHandlerConfigBuilder builder) {
        this.apiKey = builder.apiKey;
        this.apiHost = builder.apiHost;
        this.apiSSL = builder.apiSSL;
        this.regex = builder.regex;
        this.exclusionRegex = builder.exclusionRegex;
        this.exclusionHostRegex = builder.exclusionHostRegex;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.maxConnections = builder.maxConnections;
        this.proxyServer = builder.proxyServer;
        this.proxyPort = builder.proxyPort;
        this.proxySSL = builder.proxySSL;
        this.skipIps = builder.skipIps;
        this.useXForwardedHost = builder.useXForwardedHost;
        this.useForwarded = builder.useForwarded;
    }

    public String getApiKey() {
        return apiKey;
    }

    public String getApiHost() {
        return apiHost;
    }

    public boolean isApiSSL() {
        return apiSSL;
    }

    public String getRegex() {
        return regex;
    }

    public String getExclusionRegex() {
        return exclusionRegex;
    }
    public String getExclusionHostRegex() {
        return exclusionHostRegex;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public String getProxyServer() {
        return proxyServer;
    }

    public int getProxyPort() {
        return proxyPort;
    }

    public boolean isProxySSL() {
        return proxySSL;
    }
    public boolean isForwardedHost() {
        return useXForwardedHost;
    }

    public Set<String> getSkipIps() {
        return skipIps;
    }

    public boolean useForwarded() {
        return useForwarded;
    }


    public static class DataDomeRouteHandlerConfigBuilder {
        private final String apiKey;
        private String apiHost = DataDomeService.DEFAULT_API_HOST;
        private boolean apiSSL = DataDomeService.DEFAULT_API_SSL;
        private String regex = DataDomeService.DEFAULT_REGEX;
        private String exclusionRegex = DataDomeService.DEFAULT_EXCLUSION_REGEX;
        private String exclusionHostRegex = DataDomeService.DEFAULT_REGEX;

        private int connectTimeout = DataDomeService.DEFAULT_CONNECT_TIMEOUT;
        private int readTimeout = DataDomeService.DEFAULT_READ_TIMEOUT;
        private int maxConnections = DataDomeService.DEFAULT_MAX_TOTAL_CONNECTIONS;

        private String proxyServer = "";
        private int proxyPort = 0;
        private boolean proxySSL = false;
        private boolean useXForwardedHost = false;
        private boolean useForwarded = false;

        private Set<String> skipIps = Collections.emptySet();

        public DataDomeRouteHandlerConfigBuilder(final String apiKey) {
            this.apiKey = apiKey;
        }

        public DataDomeRouteHandlerConfigBuilder apiHost(final String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder apiSSL(final boolean apiSSL) {
            this.apiSSL = apiSSL;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder regex(final String regex) {
            this.regex = regex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder exclusionRegex(final String exclusionRegex) {
            this.exclusionRegex = exclusionRegex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder exclusionHostRegex(final String exclusionHostRegex) {
            this.exclusionHostRegex = exclusionHostRegex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder connectTimeout(final int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder readTimeout(final int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder maxConnections(final int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyServer(final String proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyPort(final int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxySSL(final boolean proxySSL) {
            this.proxySSL = proxySSL;
            return this;
        }
        public DataDomeRouteHandlerConfigBuilder useXForwardedHost(final boolean useXForwardedHost) {
            this.useXForwardedHost = useXForwardedHost;
            return this;
        }
        public DataDomeRouteHandlerConfigBuilder useForwarded(final boolean useForwarded) {
            this.useForwarded = useForwarded;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder skipIps(final Set<String> skipIps) {
            this.skipIps = skipIps;
            return this;
        }

        public DataDomeRouteHandlerConfig build() {
            return new DataDomeRouteHandlerConfig(this);
        }
    }
}

