/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JdbcDispatcher;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.RevisionedId;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.TableResolver;

class PostgresDispatcher<T>
implements JdbcDispatcher<T> {
    private final List<String> create;
    private final List<String> drop;
    private final List<String> grant;
    private final String insert;
    private final String truncate;
    private final TableResolver<T> resolver;

    PostgresDispatcher(List<String> create, List<String> drop, List<String> grant, String insert, String truncate, TableResolver<T> resolver) {
        this.create = create;
        this.drop = drop;
        this.grant = grant;
        this.insert = insert;
        this.truncate = truncate;
        this.resolver = resolver;
    }

    private static String asExecutableStatement(String sql) {
        return sql + (sql.endsWith(";") ? "" : ";");
    }

    public void printTo(Consumer<List<String>> consumer) {
        consumer.accept(Stream.of(Stream.of("-- creation"), this.create.stream().map(PostgresDispatcher::asExecutableStatement), Stream.of("-- grant"), this.grant.stream().map(statement -> PostgresDispatcher.asExecutableStatement(String.format(statement, "[users]"))), Stream.of("-- insert"), Stream.of(PostgresDispatcher.asExecutableStatement(this.insert)), Stream.of("-- truncate"), Stream.of(PostgresDispatcher.asExecutableStatement(this.truncate)), Stream.of("-- drop"), this.drop.stream().map(PostgresDispatcher::asExecutableStatement)).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(DataSource dataSource, Collection<String> users, Consumer<String> callback) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            for (String sql : this.create) {
                callback.accept(sql);
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    throw new SQLException("Failed to execute: " + sql, e.getSQLState(), e.getErrorCode(), e);
                }
            }
            if (users.isEmpty()) return;
            String listOfUsers = users.stream().map(String::toUpperCase).distinct().sorted().collect(Collectors.joining(", "));
            for (String statement : this.grant) {
                String sql = String.format(statement, listOfUsers);
                callback.accept(sql);
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    throw new SQLException("Failed to execute: " + sql, e.getSQLState(), e.getErrorCode(), e);
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(DataSource dataSource, Consumer<String> callback, Predicate<SQLException> check) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            ListIterator<String> it = this.drop.listIterator(this.drop.size());
            while (it.hasPrevious()) {
                String sql = it.previous();
                callback.accept(sql);
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    if (check.test(e)) continue;
                    throw new SQLException("Failed to execute: " + sql, e.getSQLState(), e.getErrorCode(), e);
                    return;
                }
            }
        }
    }

    public void insert(Connection conn, Map<RevisionedId, T> payloads) throws SQLException {
        if (payloads.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(this.insert);){
            for (Map.Entry<RevisionedId, T> payload : payloads.entrySet()) {
                ps.setString(1, payload.getKey().getId());
                ps.setLong(2, payload.getKey().getRevision());
                ps.setBoolean(3, payload.getKey().isDeleted());
                ps.setString(4, this.resolver.toPayload(payload.getValue()));
                this.resolver.registerAdditionalValues(5, ps, payload.getValue());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public void truncate(DataSource dataSource) throws SQLException {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(this.truncate);
        }
    }
}

