/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.postgres;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;

enum PostgresSqlEmitter {
    XML("XML NOT NULL", "XMLPARSE(CONTENT ?)", 1){

        @Override
        void makeView(String base, String name, List<List<PathElement>> paths, List<String> directColumns, Map<List<PathElement>, Class<?>> properties, Map<List<PathElement>, String> columns, List<String> ddl, Map<String, Map<String, String>> viewMeta, Map<String, String> objects, Function<Set<String>, Map<String, String>> namespacePrefixResolver, Function<Class<?>, String> typeResolver) {
            Map<String, String> namespaces = namespacePrefixResolver.apply(Stream.concat(paths.stream(), properties.keySet().stream()).flatMap(Collection::stream).flatMap(element -> element.getNamespace().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
            String root = "/" + PathElement.full((String)"/", Function.identity(), paths.stream().flatMap(Collection::stream).collect(Collectors.toList()), namespaces::get);
            String sqlColumns = Stream.concat(directColumns.stream(), properties.keySet().stream().map(columns::get)).collect(Collectors.joining(", "));
            String xmlColumns = properties.entrySet().stream().map(entry -> (String)columns.get(entry.getKey()) + " " + (String)typeResolver.apply((Class)entry.getValue()) + " PATH '" + PathElement.full((String)".", (String)"/", Function.identity(), (List)((List)entry.getKey()), namespaces::get) + "'").collect(Collectors.joining(", "));
            String namespace = namespaces.isEmpty() ? "" : namespaces.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> {
                if (((String)entry.getValue()).isEmpty()) {
                    throw new IllegalArgumentException("Postgres does not support a default namespace for " + (String)entry.getKey());
                }
                return "'" + (String)entry.getKey() + "' AS \"" + (String)entry.getValue() + "\"";
            }).collect(Collectors.joining(", ", "XMLNAMESPACES(", "), "));
            ddl.add("CREATE VIEW " + name + " AS SELECT " + sqlColumns + " FROM " + base + "_RAW, XMLTABLE(" + namespace + "'" + root + "' PASSING PAYLOAD COLUMNS " + xmlColumns + ")");
            objects.put(name, "VIEW");
            viewMeta.put(name, properties.keySet().stream().collect(Collectors.toMap(path -> PathElement.full((String)"/", (String)"/", Function.identity(), Stream.concat(paths.stream().flatMap(Collection::stream), path.stream()).collect(Collectors.toList()), namespaces::get), columns::get)));
        }
    }
    ,
    JSON("JSONB", "CAST(? AS JSONB)", 0){

        @Override
        void makeView(String base, String name, List<List<PathElement>> paths, List<String> directColumns, Map<List<PathElement>, Class<?>> properties, Map<List<PathElement>, String> columns, List<String> ddl, Map<String, Map<String, String>> viewMeta, Map<String, String> objects, Function<Set<String>, Map<String, String>> namespacePrefixResolver, Function<Class<?>, String> typeResolver) {
            String root = "$" + (String)(paths.isEmpty() ? "" : "." + paths.stream().map(path -> PathElement.full((String)".", Function.identity(), (List)path, namespace -> "") + "[*]").collect(Collectors.joining(".")));
            Map<List, String> types = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)typeResolver.apply((Class)entry.getValue())));
            String allColumns = Stream.concat(directColumns.stream(), properties.keySet().stream().map(path -> "CAST(" + PathElement.full((String)"EXPLODED.VALUE", (String)"->", element -> "'" + element + "'", (List)path, namespace -> "") + "->>0 AS " + (String)types.get(path) + ") AS " + (String)columns.get(path))).collect(Collectors.joining(", "));
            ddl.add("CREATE VIEW " + name + " AS SELECT " + allColumns + " FROM " + base + "_RAW, JSONB_PATH_QUERY(PAYLOAD, '" + root + "') AS EXPLODED(VALUE)");
            objects.put(name, "VIEW");
            viewMeta.put(name, properties.keySet().stream().collect(Collectors.toMap(path -> PathElement.full((String)"$", (String)".", Function.identity(), Stream.concat(paths.stream().flatMap(Collection::stream), path.stream()).collect(Collectors.toList()), namespace -> ""), columns::get)));
        }
    };

    private final String payloadType;
    private final String valueVariable;
    private final int roots;

    private PostgresSqlEmitter(String payloadType, String valueVariable, int roots) {
        this.payloadType = payloadType;
        this.valueVariable = valueVariable;
        this.roots = roots;
    }

    String getPayloadType() {
        return this.payloadType;
    }

    String getValueVariable() {
        return this.valueVariable;
    }

    int getRoots() {
        return this.roots;
    }

    abstract void makeView(String var1, String var2, List<List<PathElement>> var3, List<String> var4, Map<List<PathElement>, Class<?>> var5, Map<List<PathElement>, String> var6, List<String> var7, Map<String, Map<String, String>> var8, Map<String, String> var9, Function<Set<String>, Map<String, String>> var10, Function<Class<?>, String> var11);
}

