/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.postgres;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Year;
import java.util.Set;
import java.util.function.Function;

public class PostgresTypeResolver
implements Function<Class<?>, String> {
    private static final Set<Class<?>> NUMERIC_TYPES = Set.of(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Character.TYPE, Character.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Year.class);
    private static final Set<Class<?>> DECIMAL_TYPES = Set.of(Float.TYPE, Float.class, Double.TYPE, Double.class, Number.class, BigDecimal.class);
    private final boolean decimalsAsNumber;

    public PostgresTypeResolver(boolean decimalsAsNumber) {
        this.decimalsAsNumber = decimalsAsNumber;
    }

    @Override
    public String apply(Class<?> type) {
        if (NUMERIC_TYPES.contains(type)) {
            return "BIGINT";
        }
        if (DECIMAL_TYPES.contains(type)) {
            return this.decimalsAsNumber ? "DECIMAL" : "VARCHAR(500)";
        }
        return "TEXT";
    }
}

