/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramBucket;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.DeleteScriptRequest;
import co.elastic.clients.elasticsearch.core.DeleteScriptResponse;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.GetScriptRequest;
import co.elastic.clients.elasticsearch.core.GetScriptResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.SearchTemplateRequest;
import co.elastic.clients.elasticsearch.core.SearchTemplateResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.abasecode.opencode.es.config.ElasticsearchConfig;
import com.abasecode.opencode.es.entity.BaseT;
import com.abasecode.opencode.es.util.ElasticsearchUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchBaseClient<T extends BaseT> {
    @Autowired
    private ElasticsearchConfig.EsConfig esConfig;
    private static final String SIMPLE_SCRIPT_ID = "es-simple-script";
    private static final String DEFAULT_SCRIPT_LANG = "painless";
    private static final Integer PAGE_ONE = 1;
    private static final Integer PAGE_SIZE = 10;
    private ElasticsearchClient client;
    private RestClientTransport transport;

    @Autowired
    public ElasticsearchBaseClient(ElasticsearchConfig.EsConfig esConfig) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
        RestClientBuilder builder = RestClient.builder((Node[])((Node[])ElasticsearchUtil.getList(esConfig.getUris()).stream().toArray(Node[]::new))).setHttpClientConfigCallback(arg_0 -> ElasticsearchBaseClient.lambda$new$1((CredentialsProvider)credentialsProvider, arg_0));
        RestClient restClient = builder.build();
        this.transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient((ElasticsearchTransport)this.transport);
    }

    public ElasticsearchBaseClient(ElasticsearchClient client, RestClientTransport transport) {
        this.client = client;
        this.transport = transport;
    }

    public boolean hasIndexExist(String index) throws IOException {
        if (null != index && !index.isEmpty()) {
            return this.client.indices().exists(a -> a.index(index, new String[0])).value();
        }
        return false;
    }

    public boolean createIndex(String index, String indexJson) throws IOException {
        CreateIndexRequest request = CreateIndexRequest.of(a -> (CreateIndexRequest.Builder)a.index(index).withJson((Reader)new StringReader(indexJson)));
        return this.client.indices().create(request).acknowledged();
    }

    public boolean createIndexByJsonFile(String index, String jsonPath) throws IOException {
        if (null == jsonPath || jsonPath.isEmpty()) {
            throw new IOException("File is not exist!");
        }
        File file = new File(jsonPath);
        FileInputStream stream = new FileInputStream(file);
        CreateIndexRequest request = CreateIndexRequest.of(a -> (CreateIndexRequest.Builder)a.index(index).withJson((InputStream)stream));
        return this.client.indices().create(request).acknowledged();
    }

    public boolean deleteIndex(String index) throws IOException {
        if (null != index && !index.isEmpty() && this.hasIndexExist(index)) {
            return this.client.indices().delete(a -> a.index(index, new String[0])).acknowledged();
        }
        return false;
    }

    public boolean hasDocExist(String index, String id) throws IOException {
        if (null != index && !index.isEmpty()) {
            return this.client.exists(a -> a.index(index).id(id)).value();
        }
        return false;
    }

    public String deleteDoc(String index, String id) throws IOException {
        DeleteResponse r = this.client.delete(DeleteRequest.of(a -> a.index(index).id(id)));
        return r.result().jsonValue();
    }

    public BulkResponse deleteBulkWithList(String index, List<String> ids) throws IOException {
        BulkRequest.Builder builder = new BulkRequest.Builder();
        ids.stream().forEach(id -> builder.operations(o -> o.delete(d -> (DeleteOperation.Builder)((DeleteOperation.Builder)d.index(index)).id(id))));
        return this.client.bulk(builder.build());
    }

    public String saveOrUpdateDocByJson(String index, String json, String id, Boolean hasForce) throws IOException {
        boolean b = this.hasDocExist(index, id);
        if (b) {
            if (hasForce.booleanValue()) {
                return this.saveOrUpdateDocByJson(index, json, id);
            }
            return "exists";
        }
        return this.saveOrUpdateDocByJson(index, json, id);
    }

    private String saveOrUpdateDocByJson(String index, String json, String id) throws IOException {
        IndexResponse r = this.client.index(IndexRequest.of(a -> (IndexRequest.Builder)a.index(index).id(id).withJson((Reader)new StringReader(json))));
        return r.result().jsonValue();
    }

    public String saveOrUpdateDocByJsonFile(String index, String file, String id, Boolean hasForce) throws IOException {
        boolean b = this.hasDocExist(index, id);
        if (b) {
            if (hasForce.booleanValue()) {
                return this.saveOrUpdateDocByJsonFile(index, file, id);
            }
            return "exists";
        }
        return this.saveOrUpdateDocByJsonFile(index, file, id);
    }

    private String saveOrUpdateDocByJsonFile(String index, String file, String id) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        IndexResponse r = this.client.index(IndexRequest.of(a -> (IndexRequest.Builder)a.index(index).id(id).withJson((InputStream)stream)));
        return r.result().jsonValue();
    }

    public String saveOrUpdateDoc(String index, T t, boolean hasForce) throws IOException {
        boolean b = this.hasDocExist(index, ((BaseT)t).getId());
        if (b) {
            if (hasForce) {
                return this.saveOrUpdateDoc(index, t);
            }
            return "exists";
        }
        return this.saveOrUpdateDoc(index, t);
    }

    private String saveOrUpdateDoc(String index, T t) throws IOException {
        IndexResponse r = this.client.index(IndexRequest.of(a -> a.index(index).id(t.getId()).document(t)));
        return r.result().jsonValue();
    }

    public BulkResponse saveOrUpdateDocBulkWithJsonFiles(String index, String path) throws IOException {
        if (null == path || path.isEmpty()) {
            throw new IOException("path cannot be empty\uff01");
        }
        File[] files = new File(path).listFiles(f -> f.getName().matches(".*\\.json"));
        BulkRequest.Builder builder = new BulkRequest.Builder();
        for (File file : files) {
            JsonData json = ElasticsearchUtil.readJson(new FileInputStream(file), this.client);
            builder.operations(o -> o.index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(index)).id(json.toJson().asJsonObject().getString("id"))).document((Object)json)));
        }
        return this.client.bulk(builder.build());
    }

    public BulkResponse saveOrUpdateDocBulkWithJson(String index, List<String> jsons) throws IOException {
        if (null == jsons || jsons.isEmpty()) {
            throw new IOException("jsons cannot be empty\uff01");
        }
        BulkRequest.Builder builder = new BulkRequest.Builder();
        jsons.stream().forEach(a -> {
            JsonData json = ElasticsearchUtil.readJson(new ByteArrayInputStream(a.getBytes()), this.client);
            builder.operations(o -> o.index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(index)).id(json.toJson().asJsonObject().getString("id"))).document((Object)json)));
        });
        return this.client.bulk(builder.build());
    }

    public BulkResponse saveOrUpdateDocBulkWithList(String index, List<T> list) throws IOException {
        if (null == list || list.isEmpty()) {
            throw new IOException("list cannot be empty\uff01");
        }
        BulkRequest.Builder builder = new BulkRequest.Builder();
        list.stream().forEach(t -> builder.operations(o -> o.index(i -> ((IndexOperation.Builder)((IndexOperation.Builder)i.index(index)).id(t.getId())).document(t))));
        return this.client.bulk(builder.build());
    }

    private SearchResponse<Void> getSearchResponse(String index, String json, PageRequest pageRequest) throws IOException {
        return this.client.search(this.getSearchRequest(index, json, pageRequest), Void.class);
    }

    public SearchResponse<T> getSearchResponse(String index, String json, PageRequest pageRequest, Class<T> clazz) throws IOException {
        return this.client.search(this.getSearchRequest(index, json, pageRequest), clazz);
    }

    public SearchRequest getSearchRequest(String index, String json, PageRequest pageRequest) {
        if (pageRequest == null) {
            return SearchRequest.of(a -> ((SearchRequest.Builder)a.index(index, new String[0]).withJson((Reader)new StringReader(json))).ignoreUnavailable(Boolean.valueOf(true)));
        }
        int pageSize = pageRequest.getPageSize() <= 0 ? PAGE_SIZE.intValue() : pageRequest.getPageSize();
        int pageNumber = pageRequest.getPageNumber() <= 0 ? PAGE_ONE.intValue() : pageRequest.getPageNumber();
        int fromNum = pageSize * (pageNumber - 1);
        return SearchRequest.of(a -> ((SearchRequest.Builder)a.index(index, new String[0]).withJson((Reader)new StringReader(json))).ignoreUnavailable(Boolean.valueOf(true)).size(Integer.valueOf(pageSize)).from(Integer.valueOf(fromNum)));
    }

    public T queryById(String index, String id, Class<T> clazz) throws IOException {
        GetResponse response = this.client.get(g -> g.index(index).id(id), clazz);
        if (response.found()) {
            return (T)((BaseT)response.source());
        }
        return null;
    }

    public List<T> queryByKeywordSimple(String index, String field, String keyword, Class<T> clazz) throws IOException {
        SearchResponse response = this.client.search(s -> s.index(index, new String[0]).query(q -> q.match(t -> t.field(field).query(keyword))), clazz);
        ArrayList list = new ArrayList();
        response.hits().hits().stream().forEach(t -> list.add(t.source()));
        return list;
    }

    public List<T> queryByJson(String index, String json, Class<T> clazz) throws IOException {
        SearchResponse<T> response = this.getSearchResponse(index, json, null, clazz);
        ArrayList list = new ArrayList();
        response.hits().hits().stream().forEach(t -> list.add(t.source()));
        return list;
    }

    public Page<T> queryByJsonWithPage(String index, String json, PageRequest pageRequest, Class<T> clazz) throws IOException {
        SearchResponse<T> response = this.getSearchResponse(index, json, pageRequest, clazz);
        ArrayList list = new ArrayList();
        response.hits().hits().stream().forEach(t -> list.add(t.source()));
        return new PageImpl(list, (Pageable)pageRequest, response.hits().total().value());
    }

    public Page<T> queryByJsonWithPage(String index, String json, Integer pageNum, Integer pageSize, Class<T> clazz) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNum, (int)pageSize);
        return this.queryByJsonWithPage(index, json, pageRequest, clazz);
    }

    public List<StringTermsBucket> getStringTermsBucketByJson(String index, String aggregationJson, String aggName) throws IOException {
        SearchResponse<Void> response = this.getSearchResponse(index, aggregationJson, null);
        return ((Aggregate)response.aggregations().get(aggName)).sterms().buckets().array();
    }

    public Set<String> getSuggestionsByJson(String index, String suggestionJson, String suggestName) throws IOException {
        SearchResponse<Void> searchResponse = this.getSearchResponse(index, suggestionJson, null);
        return ((Suggestion)((List)searchResponse.suggest().get(suggestName)).get(0)).completion().options().stream().map(a -> a.text()).collect(Collectors.toSet());
    }

    public List<HistogramBucket> getHistogramBucketByJson(String index, String aggregationJson, String aggName) throws IOException {
        SearchResponse<Void> response = this.getSearchResponse(index, aggregationJson, null);
        List list = ((Aggregate)response.aggregations().get(aggName)).histogram().buckets().array();
        return list;
    }

    public void createQueryScript(String scriptId, String scriptSource, String language, boolean force) throws IOException {
        if (this.hasScriptExist(scriptId)) {
            if (force) {
                this.deleteScriptById(scriptId);
                this.createQueryScript(scriptId, scriptSource, language);
            }
        } else {
            this.createQueryScript(scriptId, scriptSource, language);
        }
    }

    private void createQueryScript(String scriptId, String scriptSource, String language) throws IOException {
        if (language == null || language.isEmpty()) {
            language = DEFAULT_SCRIPT_LANG;
        }
        String finalLanguage = language;
        this.client.putScript(r -> r.id(scriptId).script(s -> s.lang(finalLanguage).source(scriptSource)));
    }

    private void createSimpleScriptTemplate() throws IOException {
        if (!this.hasScriptExist(SIMPLE_SCRIPT_ID)) {
            String scriptTemplate = "{\"query\":{\"match\":{\"{{field}}\":\"{{value}}\"}}}";
            this.createQueryScript(SIMPLE_SCRIPT_ID, scriptTemplate, "mustache");
        }
    }

    public boolean hasScriptExist(String scriptId) throws IOException {
        GetScriptResponse script = this.client.getScript(GetScriptRequest.of(a -> a.id(scriptId)));
        return script.found();
    }

    public boolean deleteScriptById(String scriptId) throws IOException {
        if (this.hasScriptExist(scriptId)) {
            DeleteScriptResponse deleteScriptResponse = this.client.deleteScript(DeleteScriptRequest.of(a -> a.id(scriptId)));
            return deleteScriptResponse.acknowledged();
        }
        return false;
    }

    public List<T> queryBySimpleTemplate(String index, String field, String value, Class<T> clazz) throws IOException {
        this.createSimpleScriptTemplate();
        return this.queryByScriptTemplate(a -> a.index(index, new String[0]).id(SIMPLE_SCRIPT_ID).params("field", JsonData.of((Object)field)).params("value", JsonData.of((Object)value)), clazz);
    }

    public List<T> queryByScriptTemplate(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn, Class<T> clazz) throws IOException {
        SearchTemplateResponse response = this.client.searchTemplate(fn, clazz);
        ArrayList list = new ArrayList();
        response.hits().hits().stream().forEach(a -> list.add(a.source()));
        return list;
    }

    public List<T> queryByScriptTemplate(String index, String scriptId, Map<String, JsonData> map, Class<T> clazz) throws IOException {
        return this.queryByScriptTemplate(s -> s.index(index, new String[0]).id(SIMPLE_SCRIPT_ID).params(map), clazz);
    }

    public Long updateByQueryWithJson(String index, String json) throws IOException {
        return this.updateByQuery(index, json).updated();
    }

    private UpdateByQueryResponse updateByQuery(String index, String json) throws IOException {
        return this.client.updateByQuery(a -> (UpdateByQueryRequest.Builder)a.index(index, new String[0]).withJson((Reader)new StringReader(json)));
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$new$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

