/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.es.util;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Node;

public class ElasticsearchUtil {
    public static List<Node> getList(List<String> uris) {
        if (uris == null) {
            return null;
        }
        if (uris.isEmpty()) {
            return null;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < uris.size(); ++i) {
            String[] s = uris.get(i).toString().split("://");
            String[] hosts = s[1].split(":");
            HttpHost httpHost = new HttpHost(hosts[0].replace("//", ""), Integer.parseInt(hosts[1]), s[0]);
            list.add(new Node(httpHost));
        }
        return list;
    }

    public static JsonData readJson(InputStream input, ElasticsearchClient esClient) {
        JsonpMapper jsonpMapper = ((ElasticsearchTransport)esClient._transport()).jsonpMapper();
        JsonProvider jsonProvider = jsonpMapper.jsonProvider();
        return JsonData.from((JsonParser)jsonProvider.createParser(input), (JsonpMapper)jsonpMapper);
    }
}

