/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.config;

import com.abasecode.opencode.pay.plugin.alipay.constant.AliConstant;
import com.abasecode.opencode.pay.util.BaseUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class AlipayProperties
implements ApplicationRunner {
    @Bean
    @ConfigurationProperties(prefix="app.pay.alipay")
    public AliConfigParam aliConfigParam() {
        return new AliConfigParam();
    }

    public void run(ApplicationArguments args) throws Exception {
        AliConstant.appid = this.aliConfigParam().appid;
        AliConstant.appPrivateKey = this.aliConfigParam().appPrivateKey;
        AliConstant.appPublicKey = this.aliConfigParam().appPublicKey;
        AliConstant.alipayPublicKey = this.aliConfigParam().alipayPublicKey;
        AliConstant.hasDev = this.aliConfigParam().hasDev;
        AliConstant.hasEncrypt = this.aliConfigParam().hasEncrypt;
        AliConstant.encryptKey = this.aliConfigParam().encryptKey;
        AliConstant.encryptType = this.aliConfigParam().encryptType;
        AliConstant.payNotifyUrl = BaseUtils.getURI(this.aliConfigParam().baseDomain, this.aliConfigParam().payNotifyUrl);
        AliConstant.payReturnUrl = BaseUtils.getURI(this.aliConfigParam().baseDomain, this.aliConfigParam().payReturnUrl);
        AliConstant.URL_GATEWAY = AliConstant.hasDev != false ? "https://openapi.alipaydev.com/gateway.do" : "https://openapi.alipay.com/gateway.do";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlipayProperties)) {
            return false;
        }
        AlipayProperties other = (AlipayProperties)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlipayProperties;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "AlipayProperties()";
    }

    public static class AliConfigParam {
        private String appid;
        private String appPrivateKey;
        private String appPublicKey;
        private String alipayPublicKey;
        private Boolean hasDev;
        private Boolean hasEncrypt;
        private String payNotifyUrl;
        private String payReturnUrl;
        private String baseDomain;
        private String encryptKey;
        private String encryptType;

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public void setAppPrivateKey(String appPrivateKey) {
            this.appPrivateKey = appPrivateKey;
        }

        public void setAppPublicKey(String appPublicKey) {
            this.appPublicKey = appPublicKey;
        }

        public void setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
        }

        public void setHasDev(Boolean hasDev) {
            this.hasDev = hasDev;
        }

        public void setHasEncrypt(Boolean hasEncrypt) {
            this.hasEncrypt = hasEncrypt;
        }

        public void setPayNotifyUrl(String payNotifyUrl) {
            this.payNotifyUrl = payNotifyUrl;
        }

        public void setPayReturnUrl(String payReturnUrl) {
            this.payReturnUrl = payReturnUrl;
        }

        public void setBaseDomain(String baseDomain) {
            this.baseDomain = baseDomain;
        }

        public void setEncryptKey(String encryptKey) {
            this.encryptKey = encryptKey;
        }

        public void setEncryptType(String encryptType) {
            this.encryptType = encryptType;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getAppPrivateKey() {
            return this.appPrivateKey;
        }

        public String getAppPublicKey() {
            return this.appPublicKey;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public Boolean getHasDev() {
            return this.hasDev;
        }

        public Boolean getHasEncrypt() {
            return this.hasEncrypt;
        }

        public String getPayNotifyUrl() {
            return this.payNotifyUrl;
        }

        public String getPayReturnUrl() {
            return this.payReturnUrl;
        }

        public String getBaseDomain() {
            return this.baseDomain;
        }

        public String getEncryptKey() {
            return this.encryptKey;
        }

        public String getEncryptType() {
            return this.encryptType;
        }
    }
}

