/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.plugin.wechatpay.util;

import com.abasecode.opencode.pay.plugin.wechatpay.constant.WechatConstant;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.WechatCertificate;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.WechatEncryptCertificate;
import com.abasecode.opencode.pay.plugin.wechatpay.util.WechatHttp;
import com.abasecode.opencode.pay.util.BaseUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class WechatUtils {
    public static String getSerialNumber() throws Exception {
        return WechatUtils.getCertificate().getSerialNumber().toString(16).toUpperCase();
    }

    public static PrivateKey getPrivateKey() throws Exception {
        KeyStore ks = WechatUtils.getKeyStore();
        PrivateKey privateKey = (PrivateKey)ks.getKey("tenpay certificate", WechatConstant.wechatMchid.toCharArray());
        return privateKey;
    }

    private static KeyStore getKeyStore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        BufferedInputStream bis = new BufferedInputStream(BaseUtils.getStream(WechatConstant.wechatCertUrl));
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(bis, WechatConstant.wechatMchid.toCharArray());
        return ks;
    }

    private static String getKeyAlias() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        BufferedInputStream bis = new BufferedInputStream(BaseUtils.getStream(WechatConstant.wechatCertUrl));
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(bis, WechatConstant.wechatMchid.toCharArray());
        String keyAlias = null;
        Enumeration<String> aliases = ks.aliases();
        if (aliases.hasMoreElements()) {
            keyAlias = aliases.nextElement();
        }
        return keyAlias;
    }

    public static X509Certificate getCertificate() throws Exception {
        KeyStore ks = WechatUtils.getKeyStore();
        Certificate cert = ks.getCertificate("tenpay certificate");
        return (X509Certificate)cert;
    }

    public static PrivateKey getPrivateKey(String filename) throws IOException {
        String content = new String(BaseUtils.getBytes(filename), StandardCharsets.UTF_8);
        try {
            String privateKey = content.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA!", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f!");
        }
    }

    public static Map<String, X509Certificate> refreshCertificate() throws Exception {
        JSONObject jsonObject = WechatHttp.httpGet("https://api.mch.weixin.qq.com/v3/certificates", "", JSONObject.class);
        List certificateList = JSON.parseArray((String)jsonObject.getString("data"), WechatCertificate.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
        WechatCertificate newestCertificate = null;
        Date newestTime = null;
        for (WechatCertificate certificate : certificateList) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            if (newestTime == null) {
                newestCertificate = certificate;
                newestTime = formatter.parse(certificate.getEffectiveTime());
                continue;
            }
            Date effectiveTime = formatter.parse(certificate.getEffectiveTime());
            if (effectiveTime.getTime() <= newestTime.getTime()) continue;
            newestCertificate = certificate;
        }
        WechatEncryptCertificate encryptCertificate = newestCertificate.getWechatEncryptCertificate();
        String publicKey = WechatUtils.decryptToString(encryptCertificate.getAssociatedData(), encryptCertificate.getNonce(), encryptCertificate.getCiphertext());
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
        X509Certificate certificate = null;
        try {
            certificate = (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        ConcurrentHashMap<String, X509Certificate> certificateMap = new ConcurrentHashMap<String, X509Certificate>();
        certificateMap.clear();
        String serialNumber = newestCertificate.getSerialNo();
        certificateMap.put(serialNumber, certificate);
        return certificateMap;
    }

    public static String decryptToString(String associatedData, String nonce, String ciphertext) throws Exception {
        try {
            byte[] associatedDataByte = associatedData.getBytes(StandardCharsets.UTF_8);
            byte[] nonceByte = nonce.getBytes(StandardCharsets.UTF_8);
            byte[] apiV3Key = WechatConstant.wechatV3key.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(apiV3Key, "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonceByte);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedDataByte);
            return new String(cipher.doFinal(Base64.getDecoder().decode(ciphertext)), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884cAES\u89e3\u5bc6\u8bf7\u6c42\u5931\u8d25\uff01");
        }
    }
}

