/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class BaseUtils {
    public static String getURI(String domain, String url) {
        String HTTP = "http://";
        String HTTPS = "https://";
        String SLASH = "/";
        if (url.contains("http://") || url.contains("https://")) {
            return url;
        }
        if (url.indexOf("/") == 0) {
            return domain + url;
        }
        return domain + "/" + url;
    }

    public static byte[] getBytes(String path) throws IOException {
        ClassPathResource classResource = new ClassPathResource(path);
        InputStream stream = classResource.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        stream.read(bytes);
        stream.close();
        return bytes;
    }

    public static InputStream getStream(String path) throws IOException {
        return new ByteArrayInputStream(BaseUtils.getBytes(path));
    }

    public static String getNonceStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getCurrentTimeStamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static String getOrderNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        return sdf.format(new Date()) + BaseUtils.makeUUID(16);
    }

    private static String makeUUID(int len) {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, len);
    }

    public static String getCurrentUrl(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    public static String getYuanFromFen(Long m) {
        return BigDecimal.valueOf((double)m.longValue() / 100.0).toString();
    }

    public static String getYuanFromFen(int m) {
        return BigDecimal.valueOf((double)m / 100.0).toString();
    }

    public static Long getFenFromYuanLong(String m) {
        BigDecimal b = new BigDecimal(m).multiply(BigDecimal.TEN).multiply(BigDecimal.TEN);
        return Long.parseLong(b.toString());
    }

    public static int getFenFromYuan(String m) {
        if (StringUtils.isNotBlank((CharSequence)BaseUtils.getValue(m))) {
            return new BigDecimal(m).multiply(BigDecimal.valueOf(100L)).intValue();
        }
        return 0;
    }

    public static String getDateTimeStringFromRFC3339(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return "";
        }
        LocalDateTime date = LocalDateTime.parse(dateString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String getDateTimeStringFromRFC3339(Date d) {
        LocalDateTime date = LocalDateTime.parse(d.toString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalDateTime getDateTimeFromRFC3339(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        LocalDateTime date = LocalDateTime.parse(dateString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return date;
    }

    public static String getRFC3339(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        String formatDate = simpleDateFormat.format(date);
        return formatDate;
    }

    public static String getRFC3339(String datetime) {
        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZoneId shanghaiZoneId = ZoneId.of("Asia/Shanghai");
        LocalDateTime localDateTime = LocalDateTime.parse(datetime, formatter1);
        ZonedDateTime zonedDateTime = localDateTime.atZone(shanghaiZoneId);
        DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");
        String formatDate = zonedDateTime.format(formatter2);
        return formatDate;
    }

    public static String getValue(Object o) {
        if (null != o) {
            return String.valueOf(o);
        }
        return "";
    }
}

