/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay;

import com.abasecode.opencode.pay.entity.BaseOrder;
import com.abasecode.opencode.pay.entity.PayChannel;
import com.abasecode.opencode.pay.entity.PayNotify;
import com.abasecode.opencode.pay.entity.PayQueryResult;
import com.abasecode.opencode.pay.entity.PayRefundResult;
import com.abasecode.opencode.pay.entity.PayRefundResultAlipay;
import com.abasecode.opencode.pay.entity.PayRefundResultWechat;
import com.abasecode.opencode.pay.entity.PayStatus;
import com.abasecode.opencode.pay.entity.PayType;
import com.abasecode.opencode.pay.entity.PrepayResult;
import com.abasecode.opencode.pay.form.PayCloseForm;
import com.abasecode.opencode.pay.form.PayQueryForm;
import com.abasecode.opencode.pay.form.PayRefundForm;
import com.abasecode.opencode.pay.form.PayRefundQueryForm;
import com.abasecode.opencode.pay.plugin.alipay.AlipayHandler;
import com.abasecode.opencode.pay.plugin.wechatpay.WechatHandler;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Code2SessionResult;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.MicroParam;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayNotice;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayQueryReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundCreateReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundNotice;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundQueryReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.WechatClientPayParam;
import com.abasecode.opencode.pay.util.BaseUtils;
import com.alibaba.fastjson2.JSONObject;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasePay {
    @Autowired
    private WechatHandler wechatHandler;
    @Autowired
    private AlipayHandler alipayHandler;

    public PrepayResult prepay(PayChannel payChannel, PayType payType, BaseOrder order, String code) throws Exception {
        this.checkPayChannelAndType(payChannel, payType);
        if (null == order) {
            throw new Exception("\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PrepayResult result = new PrepayResult();
        if (payChannel == PayChannel.ALIPAY) {
            AlipayTradeWapPayResponse response = this.alipayHandler.prepayWap(payType, order);
            result.setUrl(response.getBody());
            result.setMsg("OK");
            return result;
        }
        if (payChannel == PayChannel.WECHAT) {
            if (payType == PayType.WECHAT_JSAPI_MP) {
                String url = this.wechatHandler.createJsapiCodeUrl(order.getOutTradeNo());
                result.setUrl(url);
                result.setMsg("OK");
                return result;
            }
            if (payType == PayType.WECHAT_JSAPI_MICRO) {
                Code2SessionResult r = this.wechatHandler.microPayGetOpenId(code);
                WechatClientPayParam payParam = this.wechatHandler.prePayJsapiMicro(PayType.WECHAT_JSAPI_MICRO, order, r.getOpenid());
                if (payParam != null) {
                    MicroParam p = new MicroParam().setPaySign(payParam.getPaySign()).setPackages(payParam.getPackages()).setTimeStamp(payParam.getTimeStamp()).setNonceStr(payParam.getNonceStr()).setSignType(payParam.getSignType());
                    result.setMsg("OK");
                    result.setParam(p);
                    return result;
                }
                result.setMsg("ERROR");
                result.setUrl("null");
            }
        }
        result.setMsg("\u76ee\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u548c\u652f\u4ed8\u5b9d\u652f\u4ed8\uff01");
        return result;
    }

    public WechatClientPayParam prepayStep2(PayChannel payChannel, PayType payType, BaseOrder order, String codeOrOpenId) throws Exception {
        System.out.println("prepayStep2\u8c03\u7528");
        this.checkPayChannelAndType(payChannel, payType);
        if (null == order) {
            throw new Exception("\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)codeOrOpenId)) {
            throw new Exception("code\u6216openId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (payChannel == PayChannel.WECHAT && payType == PayType.WECHAT_JSAPI_MP) {
            return this.wechatHandler.prePayJsapiMp(payType, order, codeOrOpenId);
        }
        throw new Exception("\u8be5\u64cd\u4f5c\u4ec5\u652f\u6301\u5fae\u4fe1\u901a\u9053!");
    }

    public PayQueryResult payQuery(PayQueryForm form) throws Exception {
        this.checkPayChannel(form.getPayChannel());
        PayQueryResult result = new PayQueryResult();
        if (form.getPayChannel() == PayChannel.ALIPAY) {
            AlipayTradeQueryModel model = new AlipayTradeQueryModel();
            model.setOutTradeNo(form.getOutTradeNo());
            model.setQueryOptions(form.getQueryOptions());
            AlipayTradeQueryResponse response = this.alipayHandler.payQuery(model);
            result.setAlipayResult(response).setPayChannel(form.getPayChannel()).setOutTradeNo(form.getOutTradeNo()).setTradeNo(response.getTradeNo()).setPayStatus(this.getPayStatus(form.getPayChannel(), response.getTradeStatus())).setTotalAmount(BaseUtils.getFenFromYuan(response.getTotalAmount())).setTotalAmountMoney(response.getTotalAmount()).setPayAmount(BaseUtils.getFenFromYuan(response.getBuyerPayAmount())).setPayAmountMoney(response.getPayAmount()).setSuccessTime(response.getSendPayDate().toString()).setWechatResult(null);
        }
        if (form.getPayChannel() == PayChannel.WECHAT) {
            PayQueryReturn response = this.wechatHandler.payQuery(form.getOutTradeNo());
            result.setWechatResult(response).setPayChannel(form.getPayChannel()).setOutTradeNo(form.getOutTradeNo()).setTradeNo(response.getTransactionId()).setPayStatus(this.getPayStatus(form.getPayChannel(), response.getTradeType())).setTotalAmount(Integer.parseInt(response.getAmount().getTotal() + "")).setTotalAmountMoney(BaseUtils.getYuanFromFen(result.getTotalAmount())).setPayAmount(Integer.parseInt(response.getAmount().getPayerTotal() + "")).setPayAmountMoney(BaseUtils.getYuanFromFen(result.getPayAmount())).setSuccessTime(BaseUtils.getDateTimeStringFromRFC3339(response.getSuccessTime())).setAlipayResult(null);
        }
        return result;
    }

    public PayNotify payNotifyWechat(PayNotice notice) throws Exception {
        PayNotice n = this.wechatHandler.payNotify(notice);
        PayNotify payNotify = new PayNotify();
        if (n.getEventType().equals("TRANSACTION.SUCCESS")) {
            payNotify.setCode(0).setPayChannel(PayChannel.WECHAT).setStatus(n.getOrigin().getTradeState()).setOutTradeNo(n.getOrigin().getOutTradeNo()).setTradeNo(n.getOrigin().getTransactionId()).setAppId(n.getOrigin().getAppid()).setSellerId(n.getOrigin().getMchid()).setTotalAmount(n.getOrigin().getAmount().getTotal()).setTotalAmountMoney(BaseUtils.getYuanFromFen(n.getOrigin().getAmount().getTotal())).setRefundAmount(0).setRefundAmountMoney("0.00").setPayTime(BaseUtils.getDateTimeStringFromRFC3339(n.getOrigin().getSuccessTime())).setNotifyTime(BaseUtils.getDateTimeStringFromRFC3339(n.getCreateTime())).setType(1);
        } else {
            payNotify.setCode(-1);
        }
        return payNotify;
    }

    public PayNotify payRefundNotifyWechat(RefundNotice notice) throws Exception {
        RefundNotice n = this.wechatHandler.payRefundNotify(notice);
        PayNotify notify = new PayNotify();
        if (n.getEventType().equals("REFUND.SUCCESS")) {
            notify.setPayChannel(PayChannel.WECHAT).setStatus(n.getOrigin().getRefundStatus()).setOutTradeNo(n.getOrigin().getOutTradeNo()).setTradeNo(n.getOrigin().getTransactionId()).setAppId("").setSellerId(n.getOrigin().getMchid()).setTotalAmount(n.getOrigin().getAmount().getTotal()).setTotalAmountMoney(BaseUtils.getYuanFromFen(n.getOrigin().getAmount().getTotal())).setRefundAmount(n.getOrigin().getAmount().getRefund()).setRefundAmountMoney(BaseUtils.getYuanFromFen(n.getOrigin().getAmount().getRefund())).setPayTime("").setNotifyTime(BaseUtils.getDateTimeStringFromRFC3339(n.getCreateTime())).setRefundTime(BaseUtils.getDateTimeStringFromRFC3339(n.getOrigin().getSuccessTime())).setCode(0).setType(2);
        } else {
            notify.setCode(-1);
        }
        return notify;
    }

    public PayNotify payNotifyAlipay(Map<String, String[]> maps) throws Exception {
        Map<String, String> params = this.alipayHandler.getNotifyMaps(maps);
        return this.getPayNotify(params);
    }

    private PayNotify getPayNotify(Map<String, String> map) {
        PayNotify notify = new PayNotify();
        String tradeStatus = map.get("trade_status");
        if (PayStatus.TRADE_CLOSED.name().equals(tradeStatus) || PayStatus.TRADE_SUCCESS.name().equals(tradeStatus)) {
            notify.setPayChannel(PayChannel.ALIPAY).setStatus(map.get("trade_status")).setOutTradeNo(map.get("out_trade_no")).setTradeNo(map.get("trade_no")).setAppId(map.get("app_id")).setSellerId(map.get("seller_id")).setTotalAmount(BaseUtils.getFenFromYuan(map.get("total_amount"))).setTotalAmountMoney(map.get("total_amount")).setPayTime(map.get("gmt_payment")).setNotifyTime(map.get("notify_time")).setCode(0);
            if (PayStatus.TRADE_CLOSED.name().equals(tradeStatus)) {
                notify.setRefundAmount(BaseUtils.getFenFromYuan(map.get("refund_fee"))).setRefundAmountMoney(map.get("refund_fee")).setRefundTime(map.get("gmt_refund")).setType(2);
            }
            if (PayStatus.TRADE_SUCCESS.name().equals(tradeStatus)) {
                notify.setRefundAmount(0).setRefundAmountMoney("0.00").setRefundTime("").setType(1);
            }
        } else {
            notify.setCode(-1);
        }
        return notify;
    }

    public void payClose(PayCloseForm form) throws Exception {
        this.checkPayChannel(form.getPayChannel());
        if (form.getPayChannel() == PayChannel.ALIPAY) {
            this.alipayHandler.payClose(form.getOutTradeNo());
        }
        if (form.getPayChannel() == PayChannel.WECHAT) {
            this.wechatHandler.payClose(form.getOutTradeNo());
        }
    }

    public PayRefundResult payRefund(PayRefundForm form) throws Exception {
        RefundCreateReturn refund;
        this.checkPayChannel(form.getPayChannel());
        if (StringUtils.isBlank((CharSequence)form.getOutRefundNo())) {
            form.setOutRefundNo(BaseUtils.getOrderNo());
        }
        PayRefundResult result = new PayRefundResult();
        if (form.getPayChannel() == PayChannel.ALIPAY) {
            JSONObject bizContent = new JSONObject();
            bizContent.put((Object)"out_trade_no", (Object)form.getOutTradeNo());
            bizContent.put((Object)"refund_amount", (Object)BaseUtils.getYuanFromFen(form.getRefundAmount()));
            if (StringUtils.isNotBlank((CharSequence)form.getRefundReason())) {
                bizContent.put((Object)"refund_reason", (Object)form.getRefundReason());
            }
            bizContent.put((Object)"out_request_no", (Object)form.getOutRefundNo());
            AlipayTradeRefundResponse refund2 = this.alipayHandler.payRefund(bizContent);
            if (Objects.equals(refund2.getCode(), "10000")) {
                result.setStatus("SUCCESS");
                PayRefundResultAlipay prra = new PayRefundResultAlipay();
                prra.setStoreName(refund2.getStoreName()).setBuyerUserId(refund2.getBuyerUserId()).setSendBackFee(refund2.getSendBackFee()).setRefundHybAmount(refund2.getRefundHybAmount()).setBuyerLogonId(refund2.getBuyerLogonId()).setFundChange(refund2.getFundChange());
                result.setPayChannel(form.getPayChannel()).setTradeNo(refund2.getTradeNo()).setOutTradeNo(refund2.getOutTradeNo()).setRefundNo(refund2.getTradeNo()).setOutRefundNo(form.getOutRefundNo()).setSuccessTime(BaseUtils.getDateTimeStringFromRFC3339(refund2.getGmtRefundPay())).setRefundAmount(BaseUtils.getFenFromYuan(refund2.getRefundFee())).setRefundAmountMoney(refund2.getRefundFee()).setRefundResultAlipay(prra);
            }
            result.setStatus(refund2.getMsg());
        }
        if (form.getPayChannel() == PayChannel.WECHAT && Objects.equals((refund = this.wechatHandler.payRefund(form.getOutTradeNo(), form.getOutRefundNo(), form.getRefundReason(), form.getRefundAmount(), form.getOrderAmount())).getCode(), "200")) {
            result.setStatus("SUCCESS");
            PayRefundResultWechat prrw = new PayRefundResultWechat();
            prrw.setAmount(refund.getAmount()).setFundsAccount(refund.getFundsAccount()).setPromotionDetail(refund.getPromotionDetail());
            result.setPayChannel(form.getPayChannel()).setOutTradeNo(refund.getOutTradeNo()).setTradeNo(refund.getTransactionId()).setRefundNo(refund.getRefundId()).setOutRefundNo(form.getOutRefundNo()).setSuccessTime(BaseUtils.getDateTimeStringFromRFC3339(refund.getSuccessTime())).setRefundAmount(refund.getAmount().getRefund()).setRefundAmountMoney(BaseUtils.getYuanFromFen(refund.getAmount().getRefund())).setRefundResultWechat(prrw);
        }
        return result;
    }

    public PayRefundResult payRefundQuery(PayRefundQueryForm form) throws Exception {
        RefundQueryReturn refund;
        this.checkPayChannel(form.getPayChannel());
        PayRefundResult result = new PayRefundResult();
        result.setPayChannel(form.getPayChannel()).setOutRefundNo(form.getOutRefundNo()).setOutTradeNo(form.getOutTradeNo());
        if (form.getPayChannel() == PayChannel.ALIPAY) {
            JSONObject bizContent = new JSONObject();
            bizContent.put((Object)"out_trade_no", (Object)form.getOutTradeNo());
            bizContent.put((Object)"out_request_no", (Object)form.getOutRefundNo());
            AlipayTradeFastpayRefundQueryResponse refund2 = this.alipayHandler.refundQuery(bizContent);
            if (Objects.equals(refund2.getCode(), "10000")) {
                result.setStatus("SUCCESS");
                PayRefundResultAlipay prra = new PayRefundResultAlipay();
                prra.setStoreName("").setBuyerUserId("").setSendBackFee(refund2.getSendBackFee()).setRefundHybAmount(refund2.getRefundHybAmount()).setBuyerLogonId("").setFundChange("");
                result.setPayChannel(form.getPayChannel()).setTradeNo(refund2.getTradeNo()).setOutTradeNo(refund2.getOutTradeNo()).setRefundNo(refund2.getTradeNo()).setOutRefundNo(form.getOutRefundNo()).setSuccessTime(BaseUtils.getDateTimeStringFromRFC3339(refund2.getGmtRefundPay())).setRefundAmount(0).setRefundAmountMoney("").setRefundResultAlipay(prra);
            }
        }
        if (form.getPayChannel() != PayChannel.WECHAT && (refund = this.wechatHandler.payRefundQuery(form.getOutRefundNo())).getStatus().equals("SUCCESS")) {
            result.setStatus("SUCCESS");
            PayRefundResultWechat prrw = new PayRefundResultWechat();
            prrw.setAmount(refund.getAmount()).setFundsAccount(refund.getFundsAccount()).setPromotionDetail(refund.getPromotionDetail());
            result.setPayChannel(form.getPayChannel()).setOutTradeNo(refund.getOutTradeNo()).setTradeNo(refund.getTransactionId()).setRefundNo(refund.getRefundId()).setOutRefundNo(form.getOutRefundNo()).setSuccessTime(BaseUtils.getDateTimeStringFromRFC3339(refund.getSuccessTime())).setRefundAmount(refund.getAmount().getRefund()).setRefundAmountMoney(BaseUtils.getYuanFromFen(refund.getAmount().getRefund())).setRefundResultWechat(prrw);
        }
        return result;
    }

    private PayStatus getPayStatus(PayChannel payChannel, String status) {
        if (payChannel == PayChannel.WECHAT) {
            switch (status) {
                case "SUCCESS": {
                    return PayStatus.TRADE_SUCCESS;
                }
                case "REFUND": {
                    return PayStatus.TRADE_REFUND;
                }
                case "NOTPAY": 
                case "USERPAYING": {
                    return PayStatus.WAIT_PAY;
                }
                case "CLOSED": 
                case "REVOKED": {
                    return PayStatus.TRADE_CLOSED;
                }
                case "PAYERROR": {
                    return PayStatus.TRADE_FAILED;
                }
            }
            return PayStatus.UNKNOWN;
        }
        if (payChannel == PayChannel.ALIPAY) {
            switch (status) {
                case "TRADE_CLOSED": {
                    return PayStatus.TRADE_CLOSED;
                }
                case "TRADE_FINISHED": {
                    return PayStatus.TRADE_FINISHED;
                }
                case "TRADE_SUCCESS": {
                    return PayStatus.TRADE_SUCCESS;
                }
                case "WAIT_BUYER_PAY": {
                    return PayStatus.WAIT_PAY;
                }
            }
            return PayStatus.UNKNOWN;
        }
        return PayStatus.UNKNOWN;
    }

    private void checkPayChannelAndType(PayChannel payChannel, PayType payType) throws Exception {
        if (payChannel == null) {
            throw new Exception("\u652f\u4ed8\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (payType == null) {
            throw new Exception("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkPayChannel(PayChannel payChannel) throws Exception {
        if (payChannel == null) {
            throw new Exception("\u652f\u4ed8\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void throwPayChannelException() throws Exception {
        throw new Exception("\u76ee\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u548c\u652f\u4ed8\u5b9d\u652f\u4ed8\uff01");
    }

    private void throwPayTypeWechatException() throws Exception {
        throw new Exception("\u76ee\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\u516c\u4f17\u53f7\u548c\u5c0f\u7a0b\u5e8f\u652f\u4ed8!");
    }

    private void throwPayTypeAlipayException() throws Exception {
        throw new Exception("\u76ee\u524d\u4ec5\u652f\u6301\u652f\u4ed8\u5b9dWAP\u652f\u4ed8!");
    }
}

