/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.plugin.wechatpay;

import com.abasecode.opencode.pay.entity.BaseOrder;
import com.abasecode.opencode.pay.entity.PayType;
import com.abasecode.opencode.pay.plugin.wechatpay.constant.WechatConstant;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.AccessToken;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.AmountOrder;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.AmountRefund;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Code2SessionResult;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Pay4Jsapi;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Pay4JsapiReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayClose;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayNotice;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayNoticeResourceOrigin;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.PayQueryReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Payer;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundCreate;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundCreateReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundNotice;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundNoticeResourceOrigin;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.RefundQueryReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.WechatClientPayParam;
import com.abasecode.opencode.pay.plugin.wechatpay.util.WechatHttp;
import com.abasecode.opencode.pay.plugin.wechatpay.util.WechatUtils;
import com.abasecode.opencode.pay.util.BaseUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatHandler {
    private static final Logger log = LoggerFactory.getLogger(WechatHandler.class);

    public String createJsapiCodeUrl(String state) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((CharSequence)state)) {
            state = "STATE";
        }
        String url = URLEncoder.encode(WechatConstant.wechatCodeReturnUrl, StandardCharsets.UTF_8.toString());
        String fullUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={APPID}&redirect_uri={REDIRECT_URI}&response_type=code&scope={SCOPE}&state={STATE}#wechat_redirect".replace("{APPID}", WechatConstant.wechatMpAppid).replace("{REDIRECT_URI}", url).replace("{SCOPE}", "snsapi_base").replace("{STATE}", state);
        return fullUrl;
    }

    public Code2SessionResult microPayGetOpenId(String code) throws Exception {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid={APPID}&secret={SECRET}&js_code={JSCODE}&grant_type=authorization_code".replace("{APPID}", WechatConstant.wechatMicroAppid).replace("{SECRET}", WechatConstant.wechatMicroSecret).replace("{JSCODE}", code);
        Code2SessionResult r = WechatHttp.httpGet(url, "", Code2SessionResult.class);
        return r;
    }

    public WechatClientPayParam prePayJsapiMp(PayType payType, BaseOrder order, String code) throws Exception {
        System.out.println("\u8fd9\u4e2a\u662f\u516c\u4f17\u53f7");
        AccessToken accessToken = this.getAccessToken(code);
        Payer payer = new Payer().setOpenid(accessToken.getOpenid());
        return this.createClientPayParam(payType, order, payer);
    }

    public WechatClientPayParam prePayJsapiMicro(PayType payType, BaseOrder order, String openId) throws Exception {
        System.out.println("\u8fd9\u4e2a\u662f\u5c0f\u7a0b\u5e8f");
        Payer payer = new Payer().setOpenid(openId);
        return this.createClientPayParam(payType, order, payer);
    }

    public PayNotice payNotify(PayNotice notice) throws Exception {
        PayNoticeResourceOrigin origin = null;
        if (notice != null && notice.getEventType().equals("TRANSACTION.SUCCESS")) {
            String s = WechatUtils.decryptToString(notice.getResource().getAssociatedData(), notice.getResource().getNonce(), notice.getResource().getCiphertext());
            origin = (PayNoticeResourceOrigin)JSONObject.parseObject((String)s, PayNoticeResourceOrigin.class);
            notice.setOrigin(origin);
        }
        return notice;
    }

    public RefundCreateReturn payRefund(String outTradeNo, String outRefundNo, String reason, int refund, int total) throws Exception {
        RefundCreate refundCreate = this.createRefundParam(outTradeNo, outRefundNo, reason, refund, total);
        String s = JSON.toJSONString((Object)refundCreate);
        RefundCreateReturn r = WechatHttp.httpPost("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds", s, RefundCreateReturn.class);
        if (r.getStatusCode() != 200) {
            r.setOutTradeNo(outTradeNo);
            r.getAmount().setRefund(refund);
            r.getAmount().setTotal(total);
            r.setOutRefundNo(refundCreate.getOutRefundNo());
        } else {
            r.setStatusCode(0);
            r.setMessage("SUCCESS");
        }
        return r;
    }

    public RefundNotice payRefundNotify(RefundNotice notice) throws Exception {
        RefundNoticeResourceOrigin origin = null;
        if (notice != null && notice.getEventType().equals("REFUND.SUCCESS")) {
            String s = WechatUtils.decryptToString(notice.getResource().getAssociatedData(), notice.getResource().getNonce(), notice.getResource().getCiphertext());
            origin = (RefundNoticeResourceOrigin)JSONObject.parseObject((String)s, RefundNoticeResourceOrigin.class);
            notice.setOrigin(origin);
        }
        return notice;
    }

    public Object payClose(String outTradeNo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String url = "https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/{out_trade_no}/close".replace("{out_trade_no}", outTradeNo);
            PayClose close = new PayClose().setMchid(WechatConstant.wechatMchid);
            Object o = WechatHttp.httpPost(url, JSON.toJSONString((Object)close), Object.class);
            return o;
        }
        throw new Exception("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public PayQueryReturn payQuery(String outTradeNo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String url = "https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/{out_trade_no}?mchid={mchid}".replace("{out_trade_no}", outTradeNo).replace("{mchid}", WechatConstant.wechatMchid);
            PayQueryReturn payQueryReturn = WechatHttp.httpGet(url, "", PayQueryReturn.class);
            return payQueryReturn;
        }
        throw new Exception("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public RefundQueryReturn payRefundQuery(String outRefundNo) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)outRefundNo)) {
            String url = "https://api.mch.weixin.qq.com/v3/refund/domestic/refunds/{out_refund_no}".replace("{out_refund_no}", outRefundNo);
            RefundQueryReturn orderQueryReturn = WechatHttp.httpGet(url, "", RefundQueryReturn.class);
            return orderQueryReturn;
        }
        throw new Exception("\u5546\u6237\u9000\u6b3e\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private Pay4Jsapi createJsapiOrderParams(PayType payType, BaseOrder baseOrder, Payer payer) {
        AmountOrder amount = new AmountOrder().setCurrency("CNY").setTotal(baseOrder.getAmount());
        Pay4Jsapi order = new Pay4Jsapi().setAppid(this.getAppId(payType)).setMchid(WechatConstant.wechatMchid).setOutTradeNo(baseOrder.getOutTradeNo()).setDescription(baseOrder.getSubject()).setNotifyUrl(WechatConstant.wechatPayNotifyUrl).setAmount(amount).setPayer(payer);
        if (StringUtils.isNotEmpty((CharSequence)baseOrder.getOtherParams())) {
            order.setAttach(baseOrder.getOtherParams());
        }
        if (StringUtils.isNotEmpty((CharSequence)baseOrder.getTimeExpire())) {
            order.setTimeExpire(baseOrder.getTimeExpire());
        }
        return order;
    }

    private RefundCreate createRefundParam(String outTradeNo, String outRefundNo, String reason, int refund, int total) {
        AmountRefund amount = new AmountRefund().setRefund(refund).setTotal(total).setCurrency("CNY");
        RefundCreate refundCreate = new RefundCreate().setOutRefundNo(outRefundNo).setAmount(amount).setNotifyUrl(WechatConstant.wechatRefundNotifyUrl).setOutTradeNo(outTradeNo).setReason(reason).setFundsAccount("AVAILABLE");
        return refundCreate;
    }

    private String getAppId(PayType payType) {
        switch (payType) {
            case WECHAT_APP: {
                return WechatConstant.wechatAppAppid;
            }
            case WECHAT_JSAPI_MICRO: {
                return WechatConstant.wechatMicroAppid;
            }
        }
        return WechatConstant.wechatMpAppid;
    }

    private AccessToken getAccessToken(String code) throws Exception {
        String accessUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={APPID}&secret={SECRET}&code={CODE}&grant_type=authorization_code".replace("{APPID}", WechatConstant.wechatMpAppid).replace("{SECRET}", WechatConstant.wechatMpSecret).replace("{CODE}", code);
        JSONObject object = WechatHttp.httpGet(accessUrl, "", JSONObject.class);
        AccessToken accessToken = new AccessToken();
        accessToken.setAccessToken(object.getString("access_token")).setExpiresIn(object.getLong("expires_in")).setRefreshToken(object.getString("refresh_token")).setOpenid(object.getString("openid")).setScope(object.getString("scope")).setIsSnapshotuser(object.getInteger("is_snapshotuser")).setErrcode(object.getString("errcode")).setErrmsg(object.getString("errmsg"));
        return accessToken;
    }

    private WechatClientPayParam createClientPayParam(PayType payType, BaseOrder baseOrder, Payer payer) throws Exception {
        String appId = this.getAppId(payType);
        Pay4Jsapi pay4Jsapi = this.createJsapiOrderParams(payType, baseOrder, payer);
        String s = JSON.toJSONString((Object)pay4Jsapi);
        Pay4JsapiReturn r = WechatHttp.httpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi", s, Pay4JsapiReturn.class);
        WechatClientPayParam param = new WechatClientPayParam().setAppid(appId).setPackages("prepay_id=" + r.getPrepayId()).setTimeStamp(BaseUtils.getCurrentTimeStamp()).setNonceStr(BaseUtils.getNonceStr()).setSignType("RSA");
        String jsapiSign = WechatHttp.getJsapiSign(appId, param.getTimeStamp(), param.getNonceStr(), param.getPackages());
        param.setPaySign(jsapiSign);
        return param;
    }
}

