/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.plugin.wechatpay;

import com.abasecode.opencode.pay.entity.BaseOrder;
import com.abasecode.opencode.pay.entity.PayType;
import com.abasecode.opencode.pay.plugin.wechatpay.constant.WechatConstant;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.AccessToken;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.AmountOrder;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Code2SessionResult;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Pay4Jsapi;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Pay4JsapiReturn;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.Payer;
import com.abasecode.opencode.pay.plugin.wechatpay.entity.WechatClientPayParam;
import com.abasecode.opencode.pay.plugin.wechatpay.util.WechatHttp;
import com.abasecode.opencode.pay.util.BaseUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Wechat {
    private static final Logger log = LoggerFactory.getLogger(Wechat.class);

    public String jsapiMpPayStep1(String state) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((CharSequence)state)) {
            state = "STATE";
        }
        String url = URLEncoder.encode(WechatConstant.wechatCodeReturnUrl, StandardCharsets.UTF_8.toString());
        String fullUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={APPID}&redirect_uri={REDIRECT_URI}&response_type=code&scope={SCOPE}&state={STATE}#wechat_redirect".replace("{APPID}", WechatConstant.wechatMpAppid).replace("{REDIRECT_URI}", url).replace("{SCOPE}", "snsapi_base").replace("{STATE}", state);
        return fullUrl;
    }

    public WechatClientPayParam jsapiMpPayStep2(PayType payType, BaseOrder order, String code) throws Exception {
        String appId = this.getAppId(payType);
        AccessToken accessToken = this.getAccessToken(code);
        Payer payer = new Payer().setOpenid(accessToken.getOpenid());
        Pay4Jsapi pay4Jsapi = this.createJsapiOrderParams(payType, order, payer);
        String s = JSON.toJSONString((Object)pay4Jsapi);
        return this.getWechatClientPayParam(appId, s);
    }

    private AccessToken getAccessToken(String code) throws Exception {
        String accessUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={APPID}&secret={SECRET}&code={CODE}&grant_type=authorization_code".replace("{APPID}", WechatConstant.wechatMpAppid).replace("{SECRET}", WechatConstant.wechatMpSecret).replace("{CODE}", code);
        JSONObject object = WechatHttp.httpGet(accessUrl, "", JSONObject.class);
        AccessToken accessToken = new AccessToken();
        accessToken.setAccessToken(object.getString("access_token")).setExpiresIn(object.getLong("expires_in")).setRefreshToken(object.getString("refresh_token")).setOpenid(object.getString("openid")).setScope(object.getString("scope")).setIsSnapshotuser(object.getInteger("is_snapshotuser")).setErrcode(object.getString("errcode")).setErrmsg(object.getString("errmsg"));
        return accessToken;
    }

    private String getAppId(PayType payType) {
        switch (payType) {
            case WECHAT_APP: {
                return WechatConstant.wechatAppAppid;
            }
            case WECHAT_JSAPI_MICRO: {
                return WechatConstant.wechatMicroAppid;
            }
        }
        return WechatConstant.wechatMpAppid;
    }

    private Pay4Jsapi createJsapiOrderParams(PayType payType, BaseOrder baseOrder, Payer payer) {
        AmountOrder amount = new AmountOrder().setCurrency("CNY").setTotal(baseOrder.getAmount());
        Pay4Jsapi order = new Pay4Jsapi().setAppid(this.getAppId(payType)).setMchid(WechatConstant.wechatMchid).setOutTradeNo(baseOrder.getOutTradeNo()).setDescription(baseOrder.getSubject()).setNotifyUrl(WechatConstant.wechatPayNotifyUrl).setAmount(amount).setPayer(payer);
        if (StringUtils.isNotEmpty((CharSequence)baseOrder.getOtherParams())) {
            order.setAttach(baseOrder.getOtherParams());
        }
        if (StringUtils.isNotEmpty((CharSequence)baseOrder.getTimeExpire())) {
            order.setTimeExpire(baseOrder.getTimeExpire());
        }
        return order;
    }

    public WechatClientPayParam jsapiMicroPay(BaseOrder order, String code) throws Exception {
        if (null == order) {
            throw new Exception("\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Code2SessionResult result = this.microPayGetOpenId(code);
        Payer payer = new Payer().setOpenid(result.getOpenid());
        String appId = this.getAppId(PayType.WECHAT_JSAPI_MICRO);
        Pay4Jsapi pay4Jsapi = this.createJsapiOrderParams(PayType.WECHAT_JSAPI_MICRO, order, payer);
        String s = JSON.toJSONString((Object)pay4Jsapi);
        return this.getWechatClientPayParam(appId, s);
    }

    private WechatClientPayParam getWechatClientPayParam(String appId, String json) throws Exception {
        Pay4JsapiReturn r = WechatHttp.httpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi", json, Pay4JsapiReturn.class);
        WechatClientPayParam param = new WechatClientPayParam().setAppid(appId).setPackages("prepay_id=" + r.getPrepayId()).setTimeStamp(BaseUtils.getCurrentTimeStamp()).setNonceStr(BaseUtils.getNonceStr()).setSignType("RSA");
        String jsapiSign = WechatHttp.getJsapiSign(appId, param.getTimeStamp(), param.getNonceStr(), param.getPackages());
        param.setPaySign(jsapiSign);
        return param;
    }

    private Code2SessionResult microPayGetOpenId(String code) throws Exception {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid={APPID}&secret={SECRET}&js_code={JSCODE}&grant_type=authorization_code".replace("{APPID}", WechatConstant.wechatMicroAppid).replace("{SECRET}", WechatConstant.wechatMicroSecret).replace("{JSCODE}", code);
        Code2SessionResult r = WechatHttp.httpGet(url, "", Code2SessionResult.class);
        return r;
    }
}

