/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.plugin.alipay;

import com.abasecode.opencode.pay.entity.BaseGoodDetail;
import com.abasecode.opencode.pay.entity.BaseOrder;
import com.abasecode.opencode.pay.entity.PayType;
import com.abasecode.opencode.pay.plugin.alipay.constant.AliConstant;
import com.abasecode.opencode.pay.plugin.alipay.entity.TradeStatus;
import com.abasecode.opencode.pay.util.BaseUtils;
import com.alibaba.fastjson2.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.domain.GoodsDetail;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayHandler {
    private static final Logger log = LoggerFactory.getLogger(AlipayHandler.class);

    public AlipayTradeWapPayResponse prepayWap(PayType payType, BaseOrder order) throws AlipayApiException {
        if (payType == PayType.ALIPAY_WAP) {
            AlipayClient alipayClient = this.createAlipayClient();
            AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
            request.setNotifyUrl(AliConstant.payNotifyUrl);
            request.setReturnUrl(AliConstant.payReturnUrl);
            request.setBizModel((AlipayObject)this.createPayParam(order));
            request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
            AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)request);
            return response;
        }
        return null;
    }

    public TradeStatus getTradeStatus(Map<String, String> map) throws Exception {
        boolean b = AlipaySignature.rsaCheckV1(map, (String)AliConstant.alipayPublicKey, (String)"utf-8", (String)"RSA2");
        if (b) {
            String trade_status = map.get("trade_status");
            if (trade_status.equals(TradeStatus.TRADE_CLOSED.name())) {
                return TradeStatus.TRADE_CLOSED;
            }
            if (trade_status.equals(TradeStatus.TRADE_FINISHED.name())) {
                return TradeStatus.TRADE_FINISHED;
            }
            if (trade_status.equals(TradeStatus.TRADE_SUCCESS.name())) {
                return TradeStatus.TRADE_SUCCESS;
            }
            if (trade_status.equals(TradeStatus.WAIT_BUYER_PAY.name())) {
                return TradeStatus.WAIT_BUYER_PAY;
            }
        }
        throw new Exception("\u56de\u8c03\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25!");
    }

    private boolean checkMap(Map<String, String> map) throws AlipayApiException {
        return AlipaySignature.rsaCheckV1(map, (String)AliConstant.alipayPublicKey, (String)"utf-8", (String)"RSA2");
    }

    private Map<String, String> getPayNotifyMap(Map<String, String[]> requestParams) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<String> iterator = requestParams.keySet().iterator();
        while (iterator.hasNext()) {
            String o;
            String name = o = iterator.next();
            String[] values = requestParams.get(name);
            Object value = "";
            for (int i = 0; i < values.length; ++i) {
                value = i == values.length - 1 ? (String)value + values[i] : (String)value + values[i] + ",";
            }
            params.put(name, (String)value);
        }
        return params;
    }

    public Map<String, String> getNotifyMaps(Map<String, String[]> requestParams) throws Exception {
        Map<String, String> map = this.getPayNotifyMap(requestParams);
        if (this.checkMap(map)) {
            return map;
        }
        throw new Exception("\u56de\u8c03\u53c2\u6570\u9a8c\u7b7e\u5931\u8d25!");
    }

    private AlipayTradeWapPayModel createPayParam(BaseOrder order) {
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(order.getOutTradeNo());
        model.setSubject(order.getSubject());
        model.setTotalAmount(BaseUtils.getYuanFromFen(order.getAmount()));
        if (StringUtils.isNotEmpty((CharSequence)order.getOtherParams())) {
            model.setPassbackParams(order.getOtherParams());
        }
        if (order.getDetails().size() > 0) {
            ArrayList<GoodsDetail> list = new ArrayList<GoodsDetail>();
            for (int i = 0; i < order.getDetails().size(); ++i) {
                BaseGoodDetail bd = order.getDetails().get(i);
                GoodsDetail d = new GoodsDetail();
                d.setGoodsId(bd.getGoodId());
                d.setBody(bd.getGoodName());
                d.setCategoriesTree(bd.getContentTree());
                d.setGoodsCategory(bd.getCategory());
                d.setPrice(BaseUtils.getYuanFromFen(bd.getPrice()));
                d.setQuantity(Long.valueOf(Long.parseLong(bd.getQuantity().toString())));
                d.setShowUrl(bd.getShowUrl());
                d.setGoodsName(bd.getGoodName());
                list.add(d);
            }
            model.setGoodsDetail(list);
        }
        return model;
    }

    public AlipayTradeQueryResponse payQuery(AlipayTradeQueryModel param) throws AlipayApiException {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizModel((AlipayObject)param);
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    public AlipayTradeRefundResponse payRefund(AlipayTradeRefundModel param) throws AlipayApiException {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setBizModel((AlipayObject)param);
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    public AlipayTradeRefundResponse payRefund(JSONObject bizContent) throws AlipayApiException {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setBizContent(bizContent.toString());
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    public AlipayTradeFastpayRefundQueryResponse refundQuery(JSONObject bizContent) throws Exception {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
        request.setBizContent(bizContent.toString());
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        AlipayTradeFastpayRefundQueryResponse response = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    public AlipayTradeCloseResponse payClose(String outTradeNo) throws AlipayApiException {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeCloseRequest request = new AlipayTradeCloseRequest();
        JSONObject bizContent = new JSONObject();
        bizContent.put((Object)"out_trade_no", (Object)outTradeNo);
        request.setBizContent(bizContent.toString());
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        request.setBizContent(bizContent.toString());
        AlipayTradeCloseResponse response = (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    public AlipayTradeCloseResponse payClose(JSONObject bizContent) throws AlipayApiException {
        AlipayClient alipayClient = this.createAlipayClient();
        AlipayTradeCloseRequest request = new AlipayTradeCloseRequest();
        request.setBizContent(bizContent.toString());
        request.setNeedEncrypt(AliConstant.hasEncrypt.booleanValue());
        request.setBizContent(bizContent.toString());
        AlipayTradeCloseResponse response = (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)request);
        return response;
    }

    private AlipayClient createAlipayClient() {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AliConstant.URL_GATEWAY, AliConstant.appid, AliConstant.appPrivateKey, "json", "utf-8", AliConstant.alipayPublicKey, "RSA2", AliConstant.encryptKey, AliConstant.encryptType);
        return alipayClient;
    }
}

