/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.plugin.wechatpay.util;

import com.abasecode.opencode.pay.plugin.wechatpay.constant.WechatConstant;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class WechatHttp {
    private static final Logger log = LoggerFactory.getLogger(WechatHttp.class);

    public static <T> T httpGet(String url, String json, Class<T> t) throws Exception {
        try {
            HttpResponse response = WechatHttp.getGetResponse(url, json);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = null;
            if (statusCode == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            return WechatHttp.getTbyResult(t, statusCode, result, t.newInstance());
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884chttp\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static <T> T httpPost(String url, String json, Class<T> t) throws Exception {
        try {
            HttpResponse response = WechatHttp.getPostResponse(url, json);
            int statusCode = response.getStatusLine().getStatusCode();
            String result = null;
            if (statusCode == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            return WechatHttp.getTbyResult(t, statusCode, result, t.newInstance());
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884chttp\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private static <T> T getTbyResult(Class<T> t, int statusCode, String jsonString, T instance) {
        JSONObject jsonObject = JSON.parseObject((String)jsonString);
        jsonObject.put((Object)"statusCode", (Object)statusCode);
        if (instance instanceof JSONObject) {
            return (T)jsonObject;
        }
        Object resultBean = JSONObject.parseObject((String)jsonObject.toString(), t);
        return (T)resultBean;
    }

    private static HttpResponse getPostResponse(String url, String json) throws Exception {
        String token = WechatHttp.httpToken("POST", url, json);
        HttpPost httppost = new HttpPost(url);
        httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
        httppost.addHeader("Accept", "application/json");
        httppost.addHeader("Accept", "text/html, application/xhtml+xml, image/jxr, */*");
        httppost.addHeader("Authorization", token);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000000).setConnectionRequestTimeout(5000000).setSocketTimeout(5000000).build();
        httppost.setConfig(requestConfig);
        if (null != json) {
            StringEntity myEntity = new StringEntity(json, StandardCharsets.UTF_8);
            httppost.setEntity((HttpEntity)myEntity);
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httppost);
            httpClient.close();
            return response;
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884chttp\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private static String httpToken(String method, String urlString, String body) throws Exception {
        Long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        String signature = WechatHttp.httpSign(method, urlString, body, timestamp, nonceStr);
        String TOKEN_PATTERN = "WECHATPAY2-SHA256-RSA2048 mchid=\"%s\",nonce_str=\"%s\",timestamp=\"%d\",serial_no=\"%s\",signature=\"%s\"";
        return String.format("WECHATPAY2-SHA256-RSA2048 mchid=\"%s\",nonce_str=\"%s\",timestamp=\"%d\",serial_no=\"%s\",signature=\"%s\"", WechatConstant.wechatMchid, nonceStr, timestamp, WechatConstant.wechatSerialNo, signature);
    }

    private static HttpResponse getGetResponse(String url, String json) throws Exception {
        String token = WechatHttp.httpToken("GET", url, json);
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("Content-Type", "application/json;charset=UTF-8");
        httpget.addHeader("Accept", "application/json");
        httpget.addHeader("Authorization", token);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            httpClient.close();
            return response;
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884chttp\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public static String httpSign(String method, String urlString, String body, long timestamp, String nonceStr) throws Exception {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new Exception("URL\u9519\u8bef\uff01");
        }
        Object signUrl = "GET".equals(method) && url.getQuery() != null ? url.getPath() + "?" + url.getQuery() : url.getPath();
        String signatureStr = Stream.of(method, signUrl, String.valueOf(timestamp), nonceStr, body).collect(Collectors.joining("\n", "", "\n"));
        return WechatHttp.getSign(signatureStr);
    }

    public static String getJsapiSign(String appId, String timestamp, String nonceStr, String packages) throws Exception {
        String signatureStr = Stream.of(appId, timestamp, nonceStr, packages).collect(Collectors.joining("\n", "", "\n"));
        return WechatHttp.getSign(signatureStr);
    }

    public static String getSign(String signatureStr) throws Exception {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(WechatConstant.wechatPrivateKey);
            sign.update(signatureStr.getBytes(StandardCharsets.UTF_8));
            return Base64Utils.encodeToString((byte[])sign.sign());
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u5f97RSA\u7b7e\u540d\u5931\u8d25!");
        }
    }
}

