/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QrCodeUtil {
    private static final String UNICODE = "utf-8";
    private static final String FORMAT = "JPG";
    private static final int QRCODE_WIDTH = 300;
    private static final int QRCODE_HEIGHT = 300;
    private static final int LOGO_WIDTH = 100;
    private static final int LOGO_HEIGHT = 100;

    private static BufferedImage createImage(String content, String logoPath) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, UNICODE);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 300, 300, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (logoPath == null || "".equals(logoPath)) {
            return image;
        }
        QrCodeUtil.addLogo(image, logoPath);
        return image;
    }

    private static void addLogo(BufferedImage source, String logoPath) throws Exception {
        File file = new File(logoPath);
        if (!file.exists()) {
            throw new Exception("logo file not found.");
        }
        Image src = ImageIO.read(new File(logoPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (width > 100) {
            width = 100;
        }
        if (height > 100) {
            height = 100;
        }
        Image image = src.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        src = image;
        Graphics2D graph = source.createGraphics();
        int x = (300 - width) / 2;
        int y = (300 - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public static String save(String content, String logoPath, String destPath) throws Exception {
        Object fileName;
        BufferedImage image = QrCodeUtil.createImage(content, logoPath);
        File file = new File(destPath);
        String path = file.getAbsolutePath();
        File filePath = new File(path);
        if (!filePath.exists() && !filePath.isDirectory()) {
            filePath.mkdirs();
        }
        fileName = ((String)fileName).substring(0, ((String)(fileName = file.getName())).indexOf(".") > 0 ? ((String)fileName).indexOf(".") : ((String)fileName).length()) + "." + FORMAT.toLowerCase();
        ImageIO.write((RenderedImage)image, FORMAT, new File(destPath));
        return fileName;
    }

    public static void encode(String content, String logoPath, OutputStream output) throws Exception {
        BufferedImage image = QrCodeUtil.createImage(content, logoPath);
        ImageIO.write((RenderedImage)image, FORMAT, output);
    }

    public static String decode(String path) throws Exception {
        File file = new File(path);
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, UNICODE);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        return result.getText();
    }
}

