/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.safe.handler;

import com.abasecode.opencode.base.code.CodeResult;
import com.abasecode.opencode.base.safe.SafeResult;
import com.abasecode.opencode.base.safe.annotation.Encrypt;
import com.abasecode.opencode.base.safe.config.SafeConfig;
import com.abasecode.opencode.base.safe.util.CodeCryptUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseHandler
implements ResponseBodyAdvice<Object> {
    @Autowired
    SafeConfig.CodeSafe codeSafe;

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return methodParameter.hasMethodAnnotation(Encrypt.class);
    }

    public SafeResult beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        try {
            CodeResult codeResult;
            String key = this.codeSafe.getKey();
            String iv = this.codeSafe.getIv();
            String secret = this.codeSafe.getSecret();
            if (body instanceof CodeResult && (codeResult = (CodeResult)body).getData() != null) {
                SafeResult safeResult = CodeCryptUtils.encryptData(codeResult, key, iv, secret);
                return safeResult;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

