/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.safe.config;

import com.abasecode.opencode.base.safe.util.CodeRsaUtils;
import java.security.PrivateKey;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class SafeConfig {
    @Bean
    @ConfigurationProperties(prefix="app.safe")
    public CodeSafe codeSafe() {
        return new CodeSafe();
    }

    public static class CodeSafe {
        private String key;
        private String iv;
        private String secret;
        private String privateKey;
        private boolean hasRsa;

        public Boolean getHasRsa() {
            return this.hasRsa;
        }

        public PrivateKey getPrivateKey() throws Exception {
            return CodeRsaUtils.getPrivateKey(this.privateKey);
        }

        public String getIv() throws Exception {
            if (!this.getHasRsa().booleanValue()) {
                return this.iv;
            }
            return CodeRsaUtils.decrypt(this.iv, this.getPrivateKey());
        }

        public String getKey() throws Exception {
            if (!this.getHasRsa().booleanValue()) {
                return this.key;
            }
            return CodeRsaUtils.decrypt(this.key, this.getPrivateKey());
        }

        public String getSecret() throws Exception {
            if (!this.getHasRsa().booleanValue()) {
                return this.secret;
            }
            return CodeRsaUtils.decrypt(this.secret, this.getPrivateKey());
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setIv(String iv) {
            this.iv = iv;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setHasRsa(boolean hasRsa) {
            this.hasRsa = hasRsa;
        }
    }
}

