/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.token.auth;

import com.abasecode.opencode.base.code.CodeException;
import com.abasecode.opencode.base.code.CodeResult;
import com.abasecode.opencode.base.token.auth.AuthToken;
import com.abasecode.opencode.base.util.CodeHttpUtils;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.springframework.web.bind.annotation.RequestMethod;

public class AuthFilter
extends AuthenticatingFilter {
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        return new AuthToken(token);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return ((HttpServletRequest)request).getMethod().equals(RequestMethod.OPTIONS.name());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)token)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Allow-Origin", CodeHttpUtils.getOrigin());
            httpResponse.setContentType("application/json;charset=UTF-8");
            String json = JSONObject.toJSONString((Object)CodeResult.error((int)401, (String)"Need authorization!"));
            httpResponse.getWriter().print(json);
            return false;
        }
        return this.executeLogin(request, response);
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, subject, request, response);
        }
        catch (AuthenticationException ex) {
            return this.onLoginFailure(token, ex, request, response);
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=UTF-8");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.setHeader("Access-Control-Allow-Origin", CodeHttpUtils.getOrigin());
        try {
            Throwable throwable = e.getCause() == null ? e : e.getCause();
            CodeResult result = CodeResult.error((int)401, (String)throwable.getMessage());
            String json = JSONObject.toJSONString((Object)result);
            httpResponse.getWriter().print(json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private String getRequestToken(HttpServletRequest httpRequest) {
        String token = "";
        try {
            token = httpRequest.getHeader("token");
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = httpRequest.getParameter("token");
            }
            return token;
        }
        catch (Exception e) {
            throw new CodeException("Token is null!");
        }
    }
}

