/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.util;

import com.abasecode.opencode.base.annotation.NameInMap;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cglib.beans.BeanMap;

public class CodeMapUtils {
    public static Map<String, Object> getMapFromEntity(Object entity) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = entity.getClass();
        CodeMapUtils.convertMap(map, clazz, entity);
        return map;
    }

    public static Map<String, String> getMapFromEntitySimple(Object entity) throws IllegalAccessException {
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = entity.getClass();
        CodeMapUtils.convertMapSimple(map, clazz, entity);
        return map;
    }

    private static void convertMap(Map<String, Object> map, Class clazz, Object target) throws IllegalAccessException {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            String key;
            NameInMap nameInMap = field.getAnnotation(NameInMap.class);
            field.setAccessible(true);
            Object value = field.get(target);
            if (nameInMap != null) {
                key = nameInMap.value();
                if (value == null) continue;
                if (nameInMap.type() == String.class) {
                    map.put(key, value);
                    continue;
                }
                if (nameInMap.type() == List.class) {
                    List values = (List)value;
                    ArrayList list = new ArrayList();
                    map.put(key, list);
                    for (Object o : values) {
                        if (CodeMapUtils.isBasicType(o)) {
                            list.add(o);
                            continue;
                        }
                        HashMap<String, Object> innerOptions = new HashMap<String, Object>();
                        list.add(innerOptions);
                        CodeMapUtils.convertMap(innerOptions, o.getClass(), o);
                    }
                    continue;
                }
                HashMap<String, Object> innerOptions = new HashMap<String, Object>();
                map.put(key, innerOptions);
                CodeMapUtils.convertMap(innerOptions, nameInMap.type(), value);
                continue;
            }
            key = field.getName();
            if (value == null) continue;
            map.put(key, value);
        }
    }

    private static void convertMapSimple(Map<String, String> map, Class clazz, Object target) throws IllegalAccessException {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            NameInMap nameInMap = field.getAnnotation(NameInMap.class);
            field.setAccessible(true);
            Object value = field.get(target);
            String key = nameInMap != null ? nameInMap.value() : field.getName();
            if (value == null) continue;
            map.put(key, value.toString());
        }
    }

    private static boolean isBasicType(Object o) {
        return o instanceof String || o instanceof Character || o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Double || o instanceof Float || o instanceof Boolean;
    }

    public static Map<String, String> getRequestParam2Map(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        while (temp.hasMoreElements()) {
            String en = (String)temp.nextElement();
            String value = request.getParameter(en);
            map.put(en, value);
        }
        return map;
    }

    public static String getRequestParam2Json(HttpServletRequest request) {
        Map<String, String> map = CodeMapUtils.getRequestParam2Map(request);
        return JSON.toJSONString(map);
    }

    public static HashMap<String, Object> getMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static Boolean getBoolValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return Boolean.parseBoolean(map.get(key).toString());
        }
        return null;
    }

    public static String getStringValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return map.get(key).toString();
        }
        return null;
    }

    public static Integer getIntegerValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return Integer.parseInt(map.get(key).toString());
        }
        return null;
    }

    public static Double getDoubleValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return Double.parseDouble(map.get(key).toString());
        }
        return null;
    }

    public static Float getFloatValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return Float.valueOf(Float.parseFloat(map.get(key).toString()));
        }
        return null;
    }

    public static BigDecimal getBigDecimalValue(Map<String, Object> map, String key) {
        if (map.get(key) != null) {
            return new BigDecimal(map.get(key).toString());
        }
        return null;
    }

    public static <T> Map<String, Object> conversionMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(String.valueOf(key), beanMap.get(key));
            }
        }
        return map;
    }
}

