/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.toolkit.qrcode;

import com.abasecode.opencode.base.toolkit.qrcode.entity.QrConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class QrCodeHandler {
    public static String createQrCode2File(String codeText, String savePath, QrConfig config) throws WriterException, IOException {
        codeText = QrCodeHandler.checkCodeText(codeText);
        File codeImgFile = QrCodeHandler.getFile(savePath);
        ImageIO.write((RenderedImage)QrCodeHandler.encodeQrCode(codeText, config), "png", codeImgFile);
        return codeImgFile.getPath();
    }

    public static void createQrCode2Stream(String codeText, OutputStream outputStream, QrConfig config) throws WriterException, IOException {
        ImageIO.write((RenderedImage)QrCodeHandler.encodeQrCode(codeText, config), "png", outputStream);
    }

    public static String decodeQrCode2Txt(String qrCodePath) {
        String qrCodeText = null;
        try {
            BufferedImage image = ImageIO.read(new File(qrCodePath));
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            Result result = new MultiFormatReader().decode(binaryBitmap, hints);
            qrCodeText = result.getText();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return qrCodeText;
    }

    private static File getFile(String filePath) {
        File file = new File(filePath);
        String savePath = "";
        String saveName = "";
        if (file.isDirectory()) {
            saveName = System.currentTimeMillis() + ".png";
            savePath = filePath;
        } else {
            saveName = StringUtils.substringAfterLast((String)(filePath = StringUtils.substringBeforeLast((String)filePath, (String)"/")), (String)"/");
            if (!StringUtils.substringAfterLast((String)saveName, (String)".").equals("png")) {
                saveName = saveName + ".png";
            }
        }
        File codeImgFile = new File(savePath, saveName);
        return codeImgFile;
    }

    private static String checkCodeText(String codeText) {
        if (codeText == null || "".equals(codeText.trim())) {
            codeText = "Create by AbaseCode.com QRCode utils.";
        }
        return codeText.trim();
    }

    private static BufferedImage encodeQrCode(String codeText, QrConfig config) {
        MatrixToImageConfig imageConfig = new MatrixToImageConfig(config.getColorFront(), config.getColorBackground());
        BufferedImage qrCode = null;
        try {
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(codeText, BarcodeFormat.QR_CODE, config.getCodeLength(), config.getCodeLength(), hints);
            qrCode = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)imageConfig);
        }
        catch (WriterException writerException) {
            // empty catch block
        }
        return qrCode;
    }
}

