/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.EnterpriseListOptions;
import com.abiquo.apiclient.domain.options.UserListOptions;
import com.abiquo.model.enumerator.AuthType;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.enterprise.EnterprisesDto;
import com.abiquo.server.core.enterprise.RoleDto;
import com.abiquo.server.core.enterprise.RolesDto;
import com.abiquo.server.core.enterprise.UserDto;
import com.abiquo.server.core.enterprise.UsersDto;
import com.abiquo.server.core.infrastructure.PublicCloudCredentialsDto;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;

public class EnterpriseApi {
    private final RestClient client;

    EnterpriseApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public EnterpriseDto createEnterprise(String name) {
        EnterpriseDto enterprise = new EnterpriseDto();
        enterprise.setName(name);
        return this.client.post("/admin/enterprises", "application/vnd.abiquo.enterprise+json", "application/vnd.abiquo.enterprise+json", (SingleResourceTransportDto)enterprise, EnterpriseDto.class);
    }

    public PublicCloudCredentialsDto addPublicCloudCredentials(EnterpriseDto enterprise, PublicCloudCredentialsDto credentials) {
        return this.client.post(String.format("%s/%s/credentials/", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.publiccloudcredentials+json", "application/vnd.abiquo.publiccloudcredentials+json", (SingleResourceTransportDto)credentials, PublicCloudCredentialsDto.class);
    }

    public EnterpriseDto getEnterprise(String id) {
        return this.client.get("/admin/enterprises/" + id, "application/vnd.abiquo.enterprise+json", EnterpriseDto.class);
    }

    public Iterable<EnterpriseDto> listEnterprises() {
        return this.client.list("/admin/enterprises", "application/vnd.abiquo.enterprises+json", EnterprisesDto.class);
    }

    public Iterable<EnterpriseDto> listEnterprises(EnterpriseListOptions options) {
        return this.client.list("/admin/enterprises", options.queryParams(), "application/vnd.abiquo.enterprises+json", EnterprisesDto.class);
    }

    public UserDto createUser(String name, String surname, String nick, String password, String email, String description, boolean active, String locale, AuthType authType, String publicSshKey, List<Integer> availableVirtualDatacentersIds, EnterpriseDto enterprise, RoleDto role) {
        UserDto user = new UserDto();
        user.setName(name);
        user.setSurname(surname);
        user.setNick(nick);
        user.setPassword(password);
        user.setEmail(email);
        user.setDescription(description);
        user.setActive(active);
        user.setLocale(locale);
        user.setAuthType(authType.toString());
        user.setPublicSshKey(publicSshKey);
        user.setAvailableVirtualDatacenters(Joiner.on((String)",").skipNulls().join(availableVirtualDatacentersIds));
        user.addLink(Links.create("role", role.getEditLink().getHref(), role.getEditLink().getType()));
        return this.client.post(enterprise.searchLink("users").getHref(), "application/vnd.abiquo.user+json", "application/vnd.abiquo.user+json", (SingleResourceTransportDto)user, UserDto.class);
    }

    public UserDto getCurrentUser() {
        return this.client.get("/login", "application/vnd.abiquo.user+json", UserDto.class);
    }

    public Iterable<UserDto> listUsers(EnterpriseDto enterprise) {
        return this.client.list(enterprise.searchLink("users").getHref(), enterprise.searchLink("users").getType(), UsersDto.class);
    }

    public Iterable<UserDto> listUsers(EnterpriseDto enterprise, UserListOptions options) {
        return this.client.list(enterprise.searchLink("users").getHref(), options.queryParams(), enterprise.searchLink("users").getType(), UsersDto.class);
    }

    public Iterable<RoleDto> listRoles() {
        return this.client.list("/admin/roles", "application/vnd.abiquo.roles+json", RolesDto.class);
    }
}

