/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.DatacenterListOptions;
import com.abiquo.apiclient.domain.options.PublicCloudRegionListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.enterprise.DatacenterLimitsDto;
import com.abiquo.server.core.enterprise.DatacentersLimitsDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.DatacentersDto;
import com.abiquo.server.core.infrastructure.MachineDto;
import com.abiquo.server.core.infrastructure.MachinesDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionsDto;
import com.abiquo.server.core.infrastructure.RackDto;
import com.abiquo.server.core.infrastructure.RacksDto;
import com.abiquo.server.core.infrastructure.RemoteServiceDto;
import com.abiquo.server.core.infrastructure.RemoteServicesDto;
import com.abiquo.server.core.infrastructure.network.NetworkServiceTypeDto;
import com.abiquo.server.core.infrastructure.network.NetworkServiceTypesDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworksDto;
import com.abiquo.server.core.infrastructure.storage.StorageDeviceDto;
import com.abiquo.server.core.infrastructure.storage.StorageDevicesDto;
import com.abiquo.server.core.infrastructure.storage.StoragePoolDto;
import com.abiquo.server.core.infrastructure.storage.StoragePoolsDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.scheduler.MachineLoadRuleDto;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;

public class InfrastructureApi {
    private final RestClient client;

    InfrastructureApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public Iterable<DatacenterDto> listDatacenters() {
        return this.client.list("/admin/datacenters", "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<DatacenterDto> listDatacenters(DatacenterListOptions options) {
        return this.client.list("/admin/datacenters", options.queryParams(), "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<RackDto> listRacks(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("racks").getHref(), "application/vnd.abiquo.racks+json", RacksDto.class);
    }

    public Iterable<DatacenterLimitsDto> listLimits(EnterpriseDto enterprise) {
        return this.client.list(enterprise.searchLink("limits"), DatacentersLimitsDto.class);
    }

    public DatacenterLimitsDto getEnterpriseLimitsForDatacenter(EnterpriseDto enterprise, DatacenterDto datacenter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("datacenter", datacenter.getId());
        return (DatacenterLimitsDto)this.client.get(enterprise.searchLink("limits").getHref(), params, "application/vnd.abiquo.limits+json", DatacentersLimitsDto.class).getCollection().get(0);
    }

    public Iterable<VLANNetworkDto> listExternalNetworks(DatacenterLimitsDto limits) {
        return this.client.list(limits.searchLink("externalnetworks").getHref(), "application/vnd.abiquo.vlans+json", VLANNetworksDto.class);
    }

    public DatacenterDto createDatacenter(String name, String location, List<RemoteServiceDto> remoteServices) {
        RemoteServicesDto remoteServicesDto = new RemoteServicesDto();
        remoteServicesDto.addAll(remoteServices);
        DatacenterDto datacenter = new DatacenterDto();
        datacenter.setName(name);
        datacenter.setLocation(location);
        datacenter.setRemoteServices(remoteServicesDto);
        return this.client.post("/admin/datacenters", "application/vnd.abiquo.datacenter+json", "application/vnd.abiquo.datacenter+json", (SingleResourceTransportDto)datacenter, DatacenterDto.class);
    }

    public PublicCloudRegionDto createPublicCloudRegion(String name, String region, String type, List<RemoteServiceDto> remoteServices) {
        RemoteServicesDto remoteServicesDto = new RemoteServicesDto();
        remoteServicesDto.addAll(remoteServices);
        PublicCloudRegionDto publicCloudRegion = new PublicCloudRegionDto();
        publicCloudRegion.setName(name);
        publicCloudRegion.setRemoteServices(remoteServicesDto);
        publicCloudRegion.addLink(new RESTLink("region", String.format("%s/%s/regions/%s", "/config/hypervisortypes", type, region)));
        return this.client.post("/admin/publiccloudregions", "application/vnd.abiquo.publiccloudregion+json", "application/vnd.abiquo.publiccloudregion+json", (SingleResourceTransportDto)publicCloudRegion, PublicCloudRegionDto.class);
    }

    public Iterable<RemoteServiceDto> listRemoteServices(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("remoteservices"), RemoteServicesDto.class);
    }

    public RackDto createRack(DatacenterDto datacenter, String name) {
        RackDto rack = new RackDto();
        rack.setName(name);
        return this.client.post(datacenter.searchLink("racks").getHref(), "application/vnd.abiquo.rack+json", "application/vnd.abiquo.rack+json", (SingleResourceTransportDto)rack, RackDto.class);
    }

    public void addDatacenterToEnterprise(EnterpriseDto enterprise, DatacenterDto datacenter) {
        DatacenterLimitsDto limits = new DatacenterLimitsDto();
        limits.addLink(Links.create("location", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()));
        this.client.post(enterprise.searchLink("limits").getHref(), "application/vnd.abiquo.limit+json", "application/vnd.abiquo.limit+json", (SingleResourceTransportDto)limits, DatacenterLimitsDto.class);
    }

    public MachinesDto discoverMachines(DatacenterDto datacenter, String type, String ip, String user, String password) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("hypervisor", type);
        queryParams.put("ip", ip);
        queryParams.put("user", user);
        queryParams.put("password", password);
        return this.client.get(datacenter.searchLink("discover").getHref(), queryParams, "application/vnd.abiquo.machines+json", MachinesDto.class);
    }

    public MachineDto createMachine(RackDto rack, MachineDto machine) {
        return this.client.post(rack.searchLink("machines").getHref(), "application/vnd.abiquo.machine+json", "application/vnd.abiquo.machine+json", (SingleResourceTransportDto)machine, MachineDto.class);
    }

    public Iterable<NetworkServiceTypeDto> listNetworkServiceTypes(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("networkservicetypes").getHref(), "application/vnd.abiquo.networkservicetypes+json", NetworkServiceTypesDto.class);
    }

    public MachineLoadRuleDto createDatacenterLoadLevelRule(DatacenterDto datacenter, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("datacenter", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    public MachineLoadRuleDto createRackLoadLevelRule(RackDto rack, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("rack", rack.getEditLink().getHref(), rack.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    public MachineLoadRuleDto createMachineLoadLevelRule(MachineDto machine, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("machine", machine.getEditLink().getHref(), machine.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    private MachineLoadRuleDto createLoadLevelRule(RESTLink targetLink, int cpuLoadPercentage, int ramLoadPercentage) {
        MachineLoadRuleDto rule = new MachineLoadRuleDto();
        rule.setCpuLoadPercentage(Integer.valueOf(cpuLoadPercentage));
        rule.setRamLoadPercentage(Integer.valueOf(ramLoadPercentage));
        rule.addLink(targetLink);
        return this.client.post("/admin/rules/machineLoadLevel", "application/vnd.abiquo.machineloadrule+json", "application/vnd.abiquo.machineloadrule+json", (SingleResourceTransportDto)rule, MachineLoadRuleDto.class);
    }

    public Iterable<StorageDeviceDto> listDevices(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("devices").getHref(), "application/vnd.abiquo.storagedevices+json", StorageDevicesDto.class);
    }

    public Iterable<StoragePoolDto> listPools(StorageDeviceDto device) {
        return this.client.list(device.searchLink("pools").getHref(), "application/vnd.abiquo.storagepools+json", StoragePoolsDto.class);
    }

    public Iterable<StoragePoolDto> listRemotePools(StorageDeviceDto device) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("sync", true);
        return this.client.list(device.searchLink("pools").getHref(), queryParams, "application/vnd.abiquo.storagepools+json", StoragePoolsDto.class);
    }

    public StorageDeviceDto createDevice(DatacenterDto datacenter, String name, String technology, String managementIp, int managementPort, String serviceIp, int servicePort, String username, String password) {
        StorageDeviceDto device = new StorageDeviceDto();
        device.addLink(Links.create("datacenter", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()));
        device.setName(name);
        device.setStorageTechnology(technology);
        device.setManagementIp(managementIp);
        device.setManagementPort(managementPort);
        device.setServiceIp(serviceIp);
        device.setServicePort(servicePort);
        device.setUsername(username);
        device.setPassword(password);
        return this.client.post(datacenter.searchLink("devices").getHref(), "application/vnd.abiquo.storagedevice+json", "application/vnd.abiquo.storagedevice+json", (SingleResourceTransportDto)device, StorageDeviceDto.class);
    }

    public StoragePoolDto createPool(DatacenterDto datacenter, StorageDeviceDto storageDevice, final String pool, final String tierName) {
        StoragePoolDto storagePool = (StoragePoolDto)Iterables.find(this.listRemotePools(storageDevice), (Predicate)new Predicate<StoragePoolDto>(){

            public boolean apply(StoragePoolDto input) {
                return input.getName().equals(pool);
            }
        });
        TierDto tier = (TierDto)Iterables.find(this.listTiers(datacenter), (Predicate)new Predicate<TierDto>(){

            public boolean apply(TierDto input) {
                return input.getName().equals(tierName);
            }
        });
        storagePool.setEnabled(true);
        storagePool.addLink(Links.create("tier", tier.getEditLink().getHref(), tier.getEditLink().getType()));
        return this.client.post(storageDevice.searchLink("pools").getHref(), "application/vnd.abiquo.storagepool+json", "application/vnd.abiquo.storagepool+json", (SingleResourceTransportDto)storagePool, StoragePoolDto.class);
    }

    public VLANNetworkDto createExternalNetwork(DatacenterDto datacenter, NetworkServiceTypeDto nst, EnterpriseDto enterprise, String name, String address, String gateway, int mask, int tag) {
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), enterprise.getEditLink().getType()));
        vlan.addLink(Links.create("networkservicetype", nst.getEditLink().getHref(), nst.getEditLink().getType()));
        vlan.setAddress(address);
        vlan.setName(name);
        vlan.setType(NetworkType.EXTERNAL);
        vlan.setMask(Integer.valueOf(mask));
        vlan.setTag(Integer.valueOf(tag));
        vlan.setGateway(gateway);
        return this.client.post(datacenter.searchLink("network").getHref(), "application/vnd.abiquo.vlan+json", "application/vnd.abiquo.vlan+json", (SingleResourceTransportDto)vlan, VLANNetworkDto.class);
    }

    public Iterable<TierDto> listTiers(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }

    public Iterable<PublicCloudRegionDto> listPublicCloudRegions(PublicCloudRegionListOptions options) {
        return this.client.list("/admin/publiccloudregions", options.queryParams(), "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Iterable<PublicCloudRegionDto> listPublicCloudRegions() {
        return this.client.list("/admin/publiccloudregions", "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }
}

