/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.TemplateListOptions;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.ConversionDto;
import com.abiquo.server.core.appslibrary.ConversionsDto;
import com.abiquo.server.core.appslibrary.DatacenterRepositoryDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionListDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplatePersistentDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateRequestDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplatesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineInstanceDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TaskState;
import com.abiquo.server.core.task.TasksDto;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.TimeUnit;

public class TemplatesApi {
    private final RestClient client;

    TemplatesApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("templates").getHref(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(VirtualDatacenterDto vdc, TemplateListOptions options) {
        return this.client.list(vdc.searchLink("templates").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(DatacenterRepositoryDto repository) {
        return this.client.list(repository.searchLink("virtualmachinetemplates").getHref(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(DatacenterRepositoryDto repository, TemplateListOptions options) {
        return this.client.list(repository.searchLink("virtualmachinetemplates").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public VirtualMachineTemplateDto instanceVirtualMachine(VirtualMachineDto vm, String snapshotName, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineInstanceDto instance = new VirtualMachineInstanceDto();
        instance.setInstanceName(snapshotName);
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vm.searchLink("instance").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachineinstance+json", (SingleResourceTransportDto)instance, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Virtual machine instance operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    public VirtualMachineTemplateDto promoteInstance(VirtualMachineTemplateDto template, String promotedName, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTemplateRequestDto promote = new VirtualMachineTemplateRequestDto();
        promote.addLink(Links.create("virtualmachinetemplate", template.getEditLink().getHref(), "application/vnd.abiquo.virtualmachinetemplate+json"));
        promote.setPromotedName(promotedName);
        AcceptedRequestDto<String> acceptedRequest = this.client.post(template.searchLink("datacenterrepository").getHref() + "/virtualmachinetemplates", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplaterequest+json", (SingleResourceTransportDto)promote, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Promote instance operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    public void refreshAppslibrary(EnterpriseDto enterprise, DatacenterDto datacenter, int pollInterval, int maxWait, TimeUnit timeUnit) {
        AcceptedRequestDto<String> acceptedRequest = this.client.put(String.format("%s/%s/actions/refresh", enterprise.searchLink("datacenterrepositories").getHref(), datacenter.getId()), "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Refresh repository operation failed");
        }
    }

    public DatacenterRepositoryDto getDatacenterRepository(EnterpriseDto enterprise, DatacenterDto datacenter) {
        return this.client.get(enterprise.searchLink("datacenterrepositories").getHref() + "/" + datacenter.getId(), "application/vnd.abiquo.datacenterrepository+json", DatacenterRepositoryDto.class);
    }

    public VirtualMachineTemplateDto createPersistent(VirtualDatacenterDto vdc, VirtualMachineTemplateDto vmt, String persistentTemplateName, TierDto tier, int pollInterval, int maxWait, TimeUnit unit) {
        VirtualMachineTemplatePersistentDto persistentTemplateDto = new VirtualMachineTemplatePersistentDto();
        persistentTemplateDto.setPersistentTemplateName(persistentTemplateName);
        persistentTemplateDto.setPersistentVolumeName(persistentTemplateDto.getPersistentTemplateName());
        persistentTemplateDto.addLink(Links.create("tier", tier.searchLink("self").getHref(), tier.searchLink("self").getType()));
        persistentTemplateDto.addLink(Links.create("virtualdatacenter", vdc.getEditLink().getHref(), vdc.getEditLink().getType()));
        persistentTemplateDto.addLink(Links.create("virtualmachinetemplate", vmt.getEditLink().getHref(), vmt.getEditLink().getType()));
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vmt.searchLink("datacenterrepository").getHref() + "/virtualmachinetemplates", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplatepersistent+json", (SingleResourceTransportDto)persistentTemplateDto, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, unit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Persistent operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    public Iterable<TaskDto> getVirtualMachineTemplateTasks(VirtualMachineTemplateDto vmt) {
        return this.client.list(vmt.searchLink("tasks").getHref(), "application/vnd.abiquo.tasks+json", TasksDto.class);
    }

    public AcceptedRequestDto<String> createConversion(VirtualMachineTemplateDto template, String targetFormat) {
        ConversionDto conversion = new ConversionDto();
        conversion.setTargetFormat(targetFormat);
        return this.client.put(String.format("%s/conversions/%s", Links.editOrSelf((SingleResourceTransportDto)template).getHref(), targetFormat), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.conversion+json", (SingleResourceTransportDto)conversion, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
    }

    public AcceptedRequestDto<String> restartConversion(ConversionDto conversion) {
        return this.client.put(Links.editOrSelf((SingleResourceTransportDto)conversion).getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.conversion+json", (SingleResourceTransportDto)conversion, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
    }

    public TemplateDefinitionListDto createTemplateDefinitionList(EnterpriseDto enterprise, String urlRepo) {
        return this.client.post(String.format("%s/%s/appslib/templateDefinitionLists", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.templatedefinitionlist+json", "text/plain", urlRepo, TemplateDefinitionListDto.class);
    }

    public VirtualMachineTemplateDto downloadTemplateToRepository(DatacenterRepositoryDto repository, TemplateDefinitionDto templateDefinition, int polling, int timeout, TimeUnit time) {
        VirtualMachineTemplateRequestDto templateDefinitionReq = new VirtualMachineTemplateRequestDto();
        templateDefinitionReq.addLink(Links.withRel("templateDefinition", templateDefinition.getEditLink()));
        AcceptedRequestDto<String> acceptedDto = this.client.post(repository.searchLink("virtualmachinetemplates").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplaterequest+json", (SingleResourceTransportDto)templateDefinitionReq, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedDto, polling, timeout, time);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Download template operation failed");
        }
        return this.client.get(task.searchLink("result"), VirtualMachineTemplateDto.class);
    }

    public ConversionDto getConversion(VirtualMachineTemplateDto vmt, String diskFormatType) {
        return this.client.get(String.format("%s/%s", vmt.searchLink("conversions").getHref(), diskFormatType), "application/vnd.abiquo.conversion+json", ConversionDto.class);
    }

    public Iterable<TaskDto> listConversionTasks(ConversionDto conversion) {
        return this.client.list(conversion.searchLink("tasks"), TasksDto.class);
    }

    public Iterable<ConversionDto> listConversions(VirtualMachineTemplateDto vmt) {
        return this.client.list(vmt.searchLink("conversions").getHref(), "application/vnd.abiquo.conversions+json", ConversionsDto.class);
    }
}

