/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain.exception;

import com.abiquo.apiclient.domain.exception.HttpException;
import com.abiquo.model.transport.error.ErrorDto;
import com.abiquo.model.transport.error.ErrorsDto;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public class AbiquoException
extends HttpException {
    private static final long serialVersionUID = 3417635717730170489L;
    private final ErrorsDto errors;

    public AbiquoException(int code, ErrorsDto errors) {
        super(code, errors.toString());
        this.errors = errors;
    }

    public ErrorsDto getErrors() {
        return this.errors;
    }

    public boolean hasError(String code) {
        return Iterables.any((Iterable)this.errors.getCollection(), AbiquoException.sameCode(code));
    }

    public ErrorDto getError(String code) {
        return (ErrorDto)Iterables.find((Iterable)this.errors.getCollection(), AbiquoException.sameCode(code));
    }

    public ErrorDto firstError() {
        return (ErrorDto)this.errors.getCollection().get(0);
    }

    private static Predicate<ErrorDto> sameCode(final String code) {
        return new Predicate<ErrorDto>(){

            public boolean apply(ErrorDto input) {
                return input.getCode().equals(code);
            }
        };
    }
}

