/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.AllowedDatacenterListOptions;
import com.abiquo.apiclient.domain.options.AllowedPublicCloudRegionListOptions;
import com.abiquo.apiclient.domain.options.ExternalIpListOptions;
import com.abiquo.apiclient.domain.options.VirtualApplianceListOptions;
import com.abiquo.apiclient.domain.options.VirtualDatacenterListOptions;
import com.abiquo.apiclient.domain.options.VirtualMachineListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.cloud.DeviceDto;
import com.abiquo.server.core.cloud.DeviceTypeDto;
import com.abiquo.server.core.cloud.DevicesDto;
import com.abiquo.server.core.cloud.FirewallPolicyDto;
import com.abiquo.server.core.cloud.FirewallRulesDto;
import com.abiquo.server.core.cloud.HardwareProfileDto;
import com.abiquo.server.core.cloud.HealthCheckDto;
import com.abiquo.server.core.cloud.HealthChecksDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressesDto;
import com.abiquo.server.core.cloud.LoadBalancerDto;
import com.abiquo.server.core.cloud.LoadBalancersDto;
import com.abiquo.server.core.cloud.RoutingRuleDto;
import com.abiquo.server.core.cloud.RoutingRulesDto;
import com.abiquo.server.core.cloud.SSLCertificateDto;
import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualApplianceState;
import com.abiquo.server.core.cloud.VirtualAppliancesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualDatacentersDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineState;
import com.abiquo.server.core.cloud.VirtualMachineStateDto;
import com.abiquo.server.core.cloud.VirtualMachineTaskDto;
import com.abiquo.server.core.cloud.VirtualMachinesDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.DatacentersDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionsDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpsDto;
import com.abiquo.server.core.infrastructure.network.NicsDto;
import com.abiquo.server.core.infrastructure.network.PublicIpDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationsDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.infrastructure.storage.VolumeManagementDto;
import com.abiquo.server.core.task.TaskDto;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CloudApi {
    private final RestClient client;

    CloudApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public VirtualDatacenterDto getVirtualDatacenter(int id) {
        return this.client.get("/cloud/virtualdatacenters/" + id, "application/vnd.abiquo.virtualdatacenter+json", VirtualDatacenterDto.class);
    }

    public VirtualDatacenterDto editVirtualDatacenter(VirtualDatacenterDto vdc) {
        return this.client.edit(vdc);
    }

    public Iterable<DatacenterDto> listAllowedDatacenters() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<DatacenterDto> listAllowedDatacenters(AllowedDatacenterListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<PublicCloudRegionDto> listAllowedPublicCloudRegions() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Iterable<PublicCloudRegionDto> listAllowedPublicCloudRegions(AllowedPublicCloudRegionListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters() {
        return this.client.list("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters(VirtualDatacenterListOptions options) {
        return this.client.list("/cloud/virtualdatacenters", options.queryParams(), "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("externalips").getHref(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc, ExternalIpListOptions options) {
        return this.client.list(vdc.searchLink("externalips").getHref(), options.queryParams(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc, VirtualApplianceListOptions options) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), options.queryParams(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public VirtualApplianceDto getVirtualAppliance(int idVdc, int idVapp) {
        return this.client.get(String.format("%s/%s/virtualappliances/%s", "/cloud/virtualdatacenters", idVdc, idVapp), "application/vnd.abiquo.virtualappliance+json", VirtualApplianceDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp, VirtualMachineListOptions options) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public VLANNetworkDto getPrivateNetwork(VirtualDatacenterDto vdc, int idNetwork) {
        return this.client.get(vdc.searchLink("privatenetworks").getHref() + "/" + idNetwork, "application/vnd.abiquo.vlan+json", VLANNetworkDto.class);
    }

    public Iterable<VMNetworkConfigurationDto> listNetworkConfigurations(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("configurations").getHref(), "application/vnd.abiquo.virtualmachinenetworkconfigurations+json", VMNetworkConfigurationsDto.class);
    }

    public VirtualMachineDto getVirtualMachine(VirtualApplianceDto vapp, int idVm) {
        return this.client.get(vapp.searchLink("virtualmachines").getHref() + "/" + idVm, "application/vnd.abiquo.virtualmachine+json", VirtualMachineDto.class);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, String vlanAddress, String vlanGateway, String vlanName) {
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.setAddress(vlanAddress);
        vlan.setGateway(vlanGateway);
        vlan.setMask(Integer.valueOf(24));
        vlan.setName(vlanName);
        vlan.setType(NetworkType.INTERNAL);
        return this.createVirtualDatacenter(location, enterprise, name, type, vlan);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, VLANNetworkDto vlan) {
        Preconditions.checkArgument((location instanceof DatacenterDto || location instanceof PublicCloudRegionDto ? 1 : 0) != 0);
        String mt = location instanceof DatacenterDto ? "application/vnd.abiquo.datacenter+json" : "application/vnd.abiquo.publiccloudregion+json";
        VirtualDatacenterDto vdc = new VirtualDatacenterDto();
        vdc.setName(name);
        vdc.setHypervisorType(type);
        vdc.setVlan(vlan);
        vdc.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), "application/vnd.abiquo.enterprise+json"));
        vdc.addLink(Links.create("location", location.searchLink("self").getHref(), mt));
        return this.client.post("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenter+json", "application/vnd.abiquo.virtualdatacenter+json", (SingleResourceTransportDto)vdc, VirtualDatacenterDto.class);
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location) {
        return this.client.post(location.searchLink("ips").getHref(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public PublicIpDto addPublicIpToVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("purchased").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public PublicIpDto releasePublicIpFromVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("topurchase").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public VirtualMachineDto assignPublicIpToVirtualMachine(PublicIpDto ip, PublicCloudRegionDto location, VirtualDatacenterDto vdc, VirtualMachineDto vm) {
        int nics = Iterables.size((Iterable)Iterables.filter((Iterable)vm.getLinks(), Links.isNic()));
        RESTLink nicLink = Links.create("nic" + nics, vdc.searchLink("purchased").getHref() + "/" + ip.getId(), "application/vnd.abiquo.publicip+json");
        vm.addLink(nicLink);
        return this.editVirtualMachine(vm, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualApplianceDto createVirtualAppliance(VirtualDatacenterDto vdc, String name) {
        VirtualApplianceDto vapp = new VirtualApplianceDto();
        vapp.setName(name);
        return this.client.post(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliance+json", "application/vnd.abiquo.virtualappliance+json", (SingleResourceTransportDto)vapp, VirtualApplianceDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        vm.addLink(Links.withRel("hardwareprofile", Links.editOrSelf((SingleResourceTransportDto)hp)));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vm.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (!refreshed.getState().isDeployed()) {
            throw new RuntimeException("Deploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vapp.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Deploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vm.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (refreshed.getState().isDeployed()) {
            throw new RuntimeException("Undeploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vapp.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.NOT_DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Undeploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto powerState(VirtualMachineDto vm, VirtualMachineState state, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineStateDto vmState = new VirtualMachineStateDto();
        vmState.setState(state);
        this.client.put(vm.searchLink("state").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinestate+json", (SingleResourceTransportDto)vmState, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (state != refreshed.getState()) {
            throw new RuntimeException("Virtual machine power state '" + state.name() + "' operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto editVirtualMachine(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineDto refreshed = null;
        if (vm.getState().isDeployed()) {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, new TypeToken<AcceptedRequestDto<String>>(){
                private static final long serialVersionUID = -6348281615419377868L;
            });
            refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
            if (VirtualMachineState.OFF != refreshed.getState()) {
                throw new RuntimeException("Virtual machine reconfigure operation failed");
            }
        } else {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm);
            refreshed = this.client.refresh(vm);
        }
        return refreshed;
    }

    public VolumeManagementDto getVolume(VirtualDatacenterDto vdc, int idVolume) {
        return this.client.get(vdc.searchLink("volumes").getHref() + "/" + idVolume, "application/vnd.abiquo.volume+json", VolumeManagementDto.class);
    }

    public VolumeManagementDto createVolume(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier) {
        VolumeManagementDto dto = new VolumeManagementDto();
        dto.setName(name);
        dto.setSizeInMB(sizeInMb);
        dto.addLink(Links.create("tier", tier.searchLink("self").getHref(), "application/vnd.abiquo.tier+json"));
        return this.client.post(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volume+json", "application/vnd.abiquo.volume+json", (SingleResourceTransportDto)dto, VolumeManagementDto.class);
    }

    public TaskDto getTask(VirtualMachineDto vm, String idTask) {
        return this.client.get(vm.searchLink("tasks").getHref() + "/" + idTask, "application/vnd.abiquo.task+json", TaskDto.class);
    }

    public Iterable<TierDto> listTiers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }

    public Iterable<DeviceDto> listDevices(LocationDto location) {
        for (RESTLink link : location.getLinks()) {
            if (!link.getRel().equals("devices") || !link.getType().equals("application/vnd.abiquo.devices+json")) continue;
            return this.client.list(link.getHref(), "application/vnd.abiquo.devices+json", DevicesDto.class);
        }
        return Collections.emptyList();
    }

    public Iterable<LoadBalancerDto> listLoadBalancers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public Iterable<LoadBalancerDto> listLoadBalancers(DeviceDto lbd) {
        return this.client.list(lbd.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public LoadBalancerDto getLoadBalacer(DeviceDto device, int idLoadBalancer) {
        return this.client.get(device.searchLink("loadbalancers").getHref() + "/" + idLoadBalancer, "application/vnd.abiquo.loadbalancer+json", LoadBalancerDto.class);
    }

    public void deleteLoadBalancer(LoadBalancerDto lbd) {
        this.client.delete((SingleResourceTransportDto)lbd);
    }

    public LoadBalancerDto editLoadBalancer(LoadBalancerDto lbd) {
        return this.client.edit(lbd);
    }

    public LoadBalancerDto createLoadBalancer(DeviceDto device, String name, String algorithm, List<RoutingRuleDto> routingRules, List<HealthCheckDto> healthChecks, List<LoadBalancerAddressDto> lbAddresses, List<FirewallPolicyDto> firewalls, Optional<VirtualDatacenterDto> vdc, Optional<VLANNetworkDto> network) {
        LoadBalancerDto lbd = new LoadBalancerDto();
        lbd.setName(name);
        lbd.setAlgorithm(algorithm);
        lbd.setHealthChecks(new HealthChecksDto());
        lbd.setRoutingRules(new RoutingRulesDto());
        lbd.setLoadBalancerAddresses(new LoadBalancerAddressesDto());
        lbd.getHealthChecks().addAll(healthChecks);
        lbd.getRoutingRules().addAll(routingRules);
        lbd.getLoadBalancerAddresses().addAll(lbAddresses);
        if (vdc.isPresent()) {
            lbd.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)vdc.get())));
        }
        if (network.isPresent()) {
            Preconditions.checkArgument((((VLANNetworkDto)network.get()).getType() == NetworkType.INTERNAL ? 1 : 0) != 0, (Object)"Only internal networks can be assigned to a load balancer");
            lbd.addLink(Links.withRel("privatenetwork", Links.editOrSelf((SingleResourceTransportDto)network.get())));
        }
        for (FirewallPolicyDto fw : firewalls) {
            lbd.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)fw)));
        }
        return this.client.post(device.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancer+json", "application/vnd.abiquo.loadbalancer+json", (SingleResourceTransportDto)lbd, LoadBalancerDto.class);
    }

    public HealthCheckDto createHealthCheck(LoadBalancerDto lbd, String name, String protocol, long intervalInMs, long timeoutInMs) {
        return this.createHealthCheck(lbd, name, protocol, intervalInMs, timeoutInMs, null, null, null);
    }

    public HealthCheckDto createHealthCheck(LoadBalancerDto lbd, String name, String protocol, long intervalInMs, long timeoutInMs, Integer attemps, Integer port, String path) {
        HealthCheckDto healthCheck = new HealthCheckDto();
        healthCheck.setName(name);
        healthCheck.setProtocol(protocol);
        healthCheck.setIntervalInMs(intervalInMs);
        healthCheck.setTimeoutInMs(timeoutInMs);
        healthCheck.setAttempts(attemps.intValue());
        healthCheck.setPort(port.intValue());
        healthCheck.setPath(path);
        return this.client.post(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthcheck+json", "application/vnd.abiquo.healthcheck+json", (SingleResourceTransportDto)healthCheck, HealthCheckDto.class);
    }

    public RoutingRuleDto createRoutingRule(LoadBalancerDto lbd, String protocolIn, String protocolOut, int portIn, int portOut, SSLCertificateDto sslCertificate) {
        RoutingRuleDto routingRule = new RoutingRuleDto();
        routingRule.setPortIn(Integer.valueOf(portIn));
        routingRule.setPortOut(Integer.valueOf(portOut));
        routingRule.setProtocolIn(protocolIn);
        routingRule.setProtocolOut(protocolOut);
        if (sslCertificate != null) {
            routingRule.setSslCertificate(sslCertificate);
        }
        return this.client.post(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrule+json", "application/vnd.abiquo.routingrule+json", (SingleResourceTransportDto)routingRule, RoutingRuleDto.class);
    }

    public Iterable<RoutingRuleDto> listRoutingRules(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrules+json", RoutingRulesDto.class);
    }

    public Iterable<HealthCheckDto> listHealthChecks(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthchecks+json", HealthChecksDto.class);
    }

    public RoutingRulesDto editRoutingRules(RoutingRulesDto routingRules) {
        for (RoutingRuleDto routingRule : routingRules.getCollection()) {
            this.editRoutingRule(routingRule);
        }
        return routingRules;
    }

    public HealthChecksDto editHealthChecks(HealthChecksDto healthChecks) {
        for (HealthCheckDto healthCheck : healthChecks.getCollection()) {
            this.editHealthCheck(healthCheck);
        }
        return healthChecks;
    }

    public void deleteRoutingRule(RoutingRuleDto routingRule) {
        this.client.delete((SingleResourceTransportDto)routingRule);
    }

    public void deleteHealthCheck(HealthCheckDto healthCheck) {
        this.client.delete((SingleResourceTransportDto)healthCheck);
    }

    public RoutingRuleDto editRoutingRule(RoutingRuleDto routingRule) {
        return this.client.edit(routingRule);
    }

    public HealthCheckDto editHealthCheck(HealthCheckDto healthCheck) {
        return this.client.edit(healthCheck);
    }

    public RoutingRuleDto getRoutingRule(LoadBalancerDto lbd, int idRoutingRule) {
        return this.client.get(lbd.searchLink("routingrules").getHref() + "/" + idRoutingRule, "application/vnd.abiquo.routingrule+json", RoutingRuleDto.class);
    }

    public HealthCheckDto getHealthCheck(LoadBalancerDto lbd, int idHealthCheck) {
        return this.client.get(lbd.searchLink("healthchecks").getHref() + "/" + idHealthCheck, "application/vnd.abiquo.healthcheck+json", HealthCheckDto.class);
    }

    public DeviceDto createDevice(LocationDto location, DeviceTypeDto deviceType, String name, boolean vdcDefault) {
        return this.createDevice(location, deviceType, name, null, null, null, null, vdcDefault);
    }

    public DeviceDto createDevice(LocationDto location, DeviceTypeDto deviceType, String name, String endpoint, String user, String password, VirtualDatacenterDto virtualDatacenter, boolean vdcDefault) {
        DeviceDto device = new DeviceDto();
        device.addLink(Links.withRel("devicetype", Links.editOrSelf((SingleResourceTransportDto)deviceType)));
        device.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)virtualDatacenter)));
        device.setName(name);
        device.setEndpoint(endpoint);
        device.setUser(user);
        device.setPassword(password);
        device.setVdcDefault(vdcDefault);
        return this.client.post(location.searchLink("devices", "devices").getHref(), "application/vnd.abiquo.device+json", "application/vnd.abiquo.device+json", (SingleResourceTransportDto)device, DeviceDto.class);
    }

    public FirewallPolicyDto createFirewallPolicy(String name, String description, DeviceDto firewallDevice, Optional<VirtualDatacenterDto> optVdc) {
        FirewallPolicyDto firewall = new FirewallPolicyDto();
        firewall.setName(name);
        firewall.setDescription(description);
        if (optVdc.isPresent()) {
            firewall.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)optVdc.get())));
        }
        return this.client.post(firewallDevice.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicy+json", "application/vnd.abiquo.firewallpolicy+json", (SingleResourceTransportDto)firewall, FirewallPolicyDto.class);
    }

    public FirewallRulesDto addFirewallRules(FirewallPolicyDto firewall, FirewallRulesDto rules) {
        return this.client.put(firewall.searchLink("rules").getHref(), "application/vnd.abiquo.firewallrules+json", "application/vnd.abiquo.firewallrules+json", (SingleResourceTransportDto)rules, FirewallRulesDto.class);
    }

    public void addFirewallToVirtualMachine(FirewallPolicyDto firewall, VirtualMachineDto vm) {
        vm.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)firewall)));
        this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm);
    }

    public NicsDto getNics(VirtualMachineDto vm) {
        return this.client.get(vm.searchLink("nics").getHref(), "application/vnd.abiquo.nics+json", NicsDto.class);
    }

    public VirtualMachineDto cloneVirtualMachine(VirtualMachineDto vm) {
        return this.client.post(vm.searchLink("clone").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachinecloneoptions+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }
}

