/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.util;

import com.google.common.base.Strings;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class LogUtils {
    private static final Logger LOG = Logger.getLogger("abiquo.client");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logRequest(Request request) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, String.format(">> %s %s", request.method(), request.url()));
            Headers headers = request.headers();
            for (String header : headers.names()) {
                LOG.log(Level.FINE, String.format(">> %s: %s", header, headers.get(header)));
            }
            RequestBody body = request.body();
            if (body != null) {
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    BufferedSink buffer = Okio.buffer((Sink)Okio.sink((OutputStream)out));
                    body.writeTo(buffer);
                    buffer.flush();
                    byte[] bytes = out.toByteArray();
                    if (bytes.length > 0) {
                        LOG.log(Level.FINE, String.format(">> Content-Type: %s", body.contentType()));
                        LOG.log(Level.FINE, String.format(">> Body: %s", new String(bytes)));
                    }
                }
            }
        }
    }

    public static void logResponse(Response response, String body) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, String.format("<< %d %s", response.code(), response.message()));
            if (!Strings.isNullOrEmpty((String)body)) {
                LOG.log(Level.FINE, String.format("<< Body: %s", body));
            }
        }
    }
}

