/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain.exception;

import com.abiquo.model.rest.RESTLink;
import com.abiquo.server.core.asynctask.AsyncJobDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;
import java.util.Comparator;
import java.util.Optional;

public class AsyncTaskFailedException
extends Exception {
    private static final long serialVersionUID = 2416588786698499247L;
    private static final String NotAvailable = "not-available";
    private final String taskLink;
    private final String message;
    private final String code;

    public AsyncTaskFailedException(AsyncTaskDto asyncTaskDto) {
        Optional<AsyncJobDto> failedJob = asyncTaskDto.getJobs().getCollection().stream().sorted(Comparator.comparing(AsyncJobDto::getSequence).reversed()).findFirst();
        if (failedJob.isPresent()) {
            this.code = failedJob.get().getErrorCode();
            this.message = failedJob.get().getErrorMessage();
        } else {
            this.code = NotAvailable;
            this.message = NotAvailable;
        }
        RESTLink selfLink = asyncTaskDto.searchLink("self");
        this.taskLink = selfLink != null ? selfLink.getHref() : NotAvailable;
    }

    public String getTaskLink() {
        return this.taskLink;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }
}

