/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.server.core.cloud.DeviceTypeDto;
import com.abiquo.server.core.cloud.DeviceTypesDto;
import com.abiquo.server.core.cloud.HypervisorTypeDto;
import com.abiquo.server.core.cloud.HypervisorTypesDto;
import com.abiquo.server.core.cloud.RegionDto;
import com.abiquo.server.core.cloud.RegionsDto;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class ConfigApi {
    private final RestClient client;

    ConfigApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public HypervisorTypeDto getHypervisorType(String type) {
        return this.client.get(String.format("%s/%s", "/config/hypervisortypes", type), "application/vnd.abiquo.hypervisortype+json", HypervisorTypeDto.class);
    }

    public Iterable<HypervisorTypeDto> getHypervisorTypes() {
        return this.client.list("/config/hypervisortypes", "application/vnd.abiquo.hypervisortypes+json", HypervisorTypesDto.class);
    }

    public DeviceTypeDto getDeviceType(String type) {
        return this.client.get(String.format("%s/%s", "/config/devicetypes", type), "application/vnd.abiquo.devicetype+json", DeviceTypeDto.class);
    }

    public Iterable<DeviceTypeDto> getDeviceTypes() {
        return this.client.list("/config/devicetypes", "application/vnd.abiquo.devicetypes+json", DeviceTypesDto.class);
    }

    public Iterable<RegionDto> getRegions(String hypervisorType) {
        return this.client.list(this.getHypervisorType(hypervisorType).searchLink("regions").getHref(), "application/vnd.abiquo.regions+json", RegionsDto.class);
    }

    public Optional<RegionDto> getRegion(String hypervisorType, String region) {
        return StreamSupport.stream(this.getRegions(hypervisorType).spliterator(), false).filter(r -> r.getName().equals(region)).findFirst();
    }
}

