/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.amtransport.DiskDto;
import com.abiquo.apiclient.amtransport.TemplateDto;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.TemplateListOptions;
import com.abiquo.model.enumerator.VMTemplateState;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.ConversionDto;
import com.abiquo.server.core.appslibrary.ConversionsDto;
import com.abiquo.server.core.appslibrary.DatacenterRepositoryDto;
import com.abiquo.server.core.appslibrary.DisksDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionListDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionListsDto;
import com.abiquo.server.core.appslibrary.TemplateDefinitionsDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplatePersistentDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateRequestDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplatesDto;
import com.abiquo.server.core.cloud.HardwareProfileDto;
import com.abiquo.server.core.cloud.HardwareProfilesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineInstanceDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.enterprise.ScopeDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TaskState;
import com.abiquo.server.core.task.TasksDto;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Uninterruptibles;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TemplatesApi {
    private final RestClient client;

    TemplatesApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("templates").getHref(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(VirtualDatacenterDto vdc, TemplateListOptions options) {
        return this.client.list(vdc.searchLink("templates").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(DatacenterRepositoryDto repository) {
        return this.client.list(repository.searchLink("virtualmachinetemplates").getHref(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public Iterable<VirtualMachineTemplateDto> listTemplates(DatacenterRepositoryDto repository, TemplateListOptions options) {
        return this.client.list(repository.searchLink("virtualmachinetemplates").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachinetemplates+json", VirtualMachineTemplatesDto.class);
    }

    public DisksDto listDisks(VirtualMachineTemplateDto template) {
        return this.client.get(template.searchLink("disks").getHref(), "application/vnd.abiquo.disks+json", DisksDto.class);
    }

    public VirtualMachineTemplateDto instanceVirtualMachine(VirtualMachineDto vm, String snapshotName, int pollInterval, int maxWait, TimeUnit timeUnit) {
        ArrayList diskLinks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)vm.getLinks(), Links.isDisk()));
        return this.instanceVirtualMachine(vm, diskLinks, snapshotName, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineTemplateDto instanceVirtualMachine(VirtualMachineDto vm, List<RESTLink> disksToInstance, String snapshotName, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineInstanceDto instance = new VirtualMachineInstanceDto();
        instance.setInstanceName(snapshotName);
        instance.getLinks().addAll(disksToInstance);
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vm.searchLink("instance").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachineinstance+json", (SingleResourceTransportDto)instance, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Virtual machine instance operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    public VirtualMachineTemplateDto promoteInstance(VirtualMachineTemplateDto template, String promotedName, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTemplateRequestDto promote = new VirtualMachineTemplateRequestDto();
        promote.addLink(Links.create("virtualmachinetemplate", template.getEditLink().getHref(), "application/vnd.abiquo.virtualmachinetemplate+json"));
        promote.setPromotedName(promotedName);
        promote.getLinks().addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)template.getLinks(), Links.isTemplateDisk())));
        AcceptedRequestDto<String> acceptedRequest = this.client.post(template.searchLink("datacenterrepository").getHref() + "/virtualmachinetemplates", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplaterequest+json", (SingleResourceTransportDto)promote, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Promote instance operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    public void refreshAppslibrary(EnterpriseDto enterprise, DatacenterDto datacenter, int pollInterval, int maxWait, TimeUnit timeUnit) {
        AcceptedRequestDto<String> acceptedRequest = this.client.put(String.format("%s/%s/actions/refresh", enterprise.searchLink("datacenterrepositories").getHref(), datacenter.getId()), "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Refresh repository operation failed");
        }
    }

    public DatacenterRepositoryDto getRepository(EnterpriseDto enterprise, SingleResourceTransportDto datacenter) {
        Preconditions.checkArgument((datacenter instanceof DatacenterDto || datacenter instanceof PublicCloudRegionDto ? 1 : 0) != 0);
        int id = datacenter instanceof DatacenterDto ? ((DatacenterDto)datacenter).getId() : ((PublicCloudRegionDto)datacenter).getId();
        return this.client.get(enterprise.searchLink("datacenterrepositories").getHref() + "/" + id, "application/vnd.abiquo.datacenterrepository+json", DatacenterRepositoryDto.class);
    }

    public VirtualMachineTemplateDto createPersistent(VirtualDatacenterDto vdc, VirtualMachineTemplateDto vmt, String persistentTemplateName, TierDto tier, int pollInterval, int maxWait, TimeUnit unit) {
        VirtualMachineTemplatePersistentDto persistentTemplateDto = new VirtualMachineTemplatePersistentDto();
        persistentTemplateDto.setPersistentTemplateName(persistentTemplateName);
        for (RESTLink disk : Iterables.filter((Iterable)vmt.getLinks(), Links.isTemplateDisk())) {
            Integer seq = Integer.valueOf(disk.getRel().substring("disk".length()));
            RESTLink tierOfDisk = Links.withRel("tier" + seq, Links.editOrSelf((SingleResourceTransportDto)tier));
            persistentTemplateDto.addLink(disk);
            persistentTemplateDto.addLink(tierOfDisk);
        }
        persistentTemplateDto.addLink(Links.create("virtualdatacenter", vdc.getEditLink().getHref(), vdc.getEditLink().getType()));
        persistentTemplateDto.addLink(Links.create("virtualmachinetemplate", vmt.getEditLink().getHref(), vmt.getEditLink().getType()));
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vmt.searchLink("datacenterrepository").getHref() + "/virtualmachinetemplates", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplatepersistent+json", (SingleResourceTransportDto)persistentTemplateDto, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, unit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Persistent operation failed");
        }
        return this.client.get(task.searchLink("result").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", VirtualMachineTemplateDto.class);
    }

    private HardwareProfilesDto listHardwareProfilesLocation(LocationDto location) {
        return this.client.get(location.searchLink("hardwareprofiles").getHref(), (Map<String, Object>)ImmutableMap.of((Object)"limit", (Object)"0"), "application/vnd.abiquo.hardwareprofiles+json", HardwareProfilesDto.class);
    }

    public HardwareProfilesDto listHardwareProfiles(PublicCloudRegionDto pcrLocation) {
        return this.listHardwareProfilesLocation((LocationDto)pcrLocation);
    }

    public HardwareProfilesDto listHardwareProfiles(DatacenterDto dcLocation) {
        return this.listHardwareProfilesLocation((LocationDto)dcLocation);
    }

    public Iterable<TaskDto> getVirtualMachineTemplateTasks(VirtualMachineTemplateDto vmt) {
        return this.client.list(vmt.searchLink("tasks").getHref(), "application/vnd.abiquo.tasks+json", TasksDto.class);
    }

    public AcceptedRequestDto<String> createConversion(VirtualMachineTemplateDto template, String targetFormat) {
        ConversionDto conversion = new ConversionDto();
        conversion.setTargetFormat(targetFormat);
        return this.client.put(String.format("%s/conversions/%s", Links.editOrSelf((SingleResourceTransportDto)template).getHref(), targetFormat), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.conversion+json", (SingleResourceTransportDto)conversion, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
    }

    public AcceptedRequestDto<String> restartConversion(ConversionDto conversion) {
        return this.client.put(Links.editOrSelf((SingleResourceTransportDto)conversion).getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.conversion+json", (SingleResourceTransportDto)conversion, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
    }

    public TemplateDefinitionListDto createTemplateDefinitionList(EnterpriseDto enterprise, String urlRepo) {
        return this.client.post(String.format("%s/%s/appslib/templateDefinitionLists", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.templatedefinitionlist+json", "text/plain", urlRepo, TemplateDefinitionListDto.class);
    }

    public TemplateDefinitionListsDto listTemplateDefinitionLists(EnterpriseDto enterprise) {
        return this.client.get(String.format("%s/%s/appslib/templateDefinitionLists", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.templatedefinitionlists+json", TemplateDefinitionListsDto.class);
    }

    public TemplateDefinitionsDto listTemplateDefinitions(EnterpriseDto enterprise) {
        return this.client.get(String.format("%s/%s/appslib/templateDefinitions", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.templatedefinitions+json", TemplateDefinitionsDto.class);
    }

    public VirtualMachineTemplateDto downloadTemplateToRepository(DatacenterRepositoryDto repository, TemplateDefinitionDto templateDefinition, int polling, int timeout, TimeUnit time) {
        VirtualMachineTemplateRequestDto templateDefinitionReq = new VirtualMachineTemplateRequestDto();
        templateDefinitionReq.addLink(Links.withRel("templateDefinition", templateDefinition.getEditLink()));
        AcceptedRequestDto<String> acceptedDto = this.client.post(repository.searchLink("virtualmachinetemplates").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetemplaterequest+json", (SingleResourceTransportDto)templateDefinitionReq, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        TaskDto task = this.client.waitForTask(acceptedDto, polling, timeout, time);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Download template operation failed");
        }
        return this.client.get(task.searchLink("result"), VirtualMachineTemplateDto.class);
    }

    public VirtualMachineTemplateDto createPublicTemplate(DatacenterRepositoryDto repository, VirtualMachineTemplateDto template) {
        return this.client.post(repository.searchLink("virtualmachinetemplates").getHref(), "application/vnd.abiquo.virtualmachinetemplate+json", "application/vnd.abiquo.virtualmachinetemplate+json", (SingleResourceTransportDto)template, VirtualMachineTemplateDto.class);
    }

    public ConversionDto getConversion(VirtualMachineTemplateDto vmt, String diskFormatType) {
        return this.client.get(String.format("%s/%s", vmt.searchLink("conversions").getHref(), diskFormatType), "application/vnd.abiquo.conversion+json", ConversionDto.class);
    }

    public Iterable<TaskDto> listConversionTasks(ConversionDto conversion) {
        return this.client.list(conversion.searchLink("tasks"), TasksDto.class);
    }

    public Iterable<ConversionDto> listConversions(VirtualMachineTemplateDto vmt) {
        return this.client.list(vmt.searchLink("conversions").getHref(), "application/vnd.abiquo.conversions+json", ConversionsDto.class);
    }

    public VirtualMachineTemplateDto waitWhileInProgress(VirtualMachineTemplateDto vmt, int pollInterval, int maxWait, TimeUnit timeUnit) {
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < (long)maxWait) {
            VirtualMachineTemplateDto refreshed = this.client.refresh(vmt);
            if (!VMTemplateState.IN_PROGRESS.equals((Object)refreshed.getState())) {
                return refreshed;
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        throw new RuntimeException("Virtual machine template did not reach the desired state in the configured timeout");
    }

    public String uploadTemplateDefinition(DatacenterRepositoryDto repository, String templateName, String templateDescription, Integer requiredCpu, Long requiredRamInMB, String iconURL, String categoryName, String virtualMachineTemplateUrl, Long diskRequiredRamInMb, String fileFormat, File file) {
        TemplateDto template = new TemplateDto();
        template.setName(templateName);
        template.setDescription(templateDescription);
        template.setRequiredCpu(requiredCpu);
        template.setRequiredRamInMB(requiredRamInMB);
        template.setIconUrl(iconURL);
        template.setCategoryName(categoryName);
        DiskDto disk = new DiskDto();
        disk.setVirtualMachineTemplateUrl(virtualMachineTemplateUrl);
        disk.setRequiredHDInMB(diskRequiredRamInMb);
        disk.setDiskFileFormat(fileFormat);
        template.getDisks().add(disk);
        try {
            Response response = this.client.multipartPost(repository.searchLink("applianceManagerRepositoryUri").getHref() + "/templates", "diskInfo", this.client.json().write(template), "diskFile", file);
            return response.header("Location");
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public VirtualMachineTemplateDto addScope(VirtualMachineTemplateDto vmt, ScopeDto scope) {
        RESTLink link = Links.withRel("scope", scope.getEditLink());
        vmt.addLink(link);
        return this.client.edit(vmt);
    }

    public VirtualMachineTemplateDto removeScope(VirtualMachineTemplateDto vmt, ScopeDto scope) {
        Iterator it = vmt.getLinks().iterator();
        while (it.hasNext()) {
            RESTLink link = (RESTLink)it.next();
            if (!scope.getName().equals(link.getTitle())) continue;
            it.remove();
        }
        return this.client.edit(vmt);
    }

    public HardwareProfileDto createHardwareProfile(LocationDto location, HardwareProfileDto hardwareProfile) {
        return this.client.post(location.searchLink("hardwareprofiles").getHref(), "application/vnd.abiquo.hardwareprofile+json", "application/vnd.abiquo.hardwareprofile+json", (SingleResourceTransportDto)hardwareProfile, HardwareProfileDto.class);
    }
}

