/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.interceptors;

import com.abiquo.apiclient.auth.Authentication;
import com.abiquo.apiclient.auth.TokenAuthentication;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;

public class AuthenticationInterceptor
implements Interceptor {
    private final Authentication initialAuthentication;
    private Authentication tokenAuthentication;

    public AuthenticationInterceptor(Authentication authentication) {
        this.initialAuthentication = (Authentication)Preconditions.checkNotNull((Object)authentication, (Object)"authentication cannot be null");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String token;
        Request authenticated = this.getAuthentication().authenticate(chain.request());
        Response response = chain.proceed(authenticated);
        if (this.getAuthentication().allowAbiquoToken() && (token = response.header("X-Abiquo-Token")) != null) {
            this.tokenAuthentication = TokenAuthentication.token(token);
        }
        return response;
    }

    private Authentication getAuthentication() {
        return this.tokenAuthentication != null ? this.tokenAuthentication : this.initialAuthentication;
    }
}

