/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.ApiClient;
import com.abiquo.apiclient.AsyncTaskUtils;
import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.exception.AsyncTaskFailedException;
import com.abiquo.apiclient.domain.options.AllowedDatacenterListOptions;
import com.abiquo.apiclient.domain.options.AllowedPublicCloudRegionListOptions;
import com.abiquo.apiclient.domain.options.EventListOptions;
import com.abiquo.apiclient.domain.options.ExternalIpListOptions;
import com.abiquo.apiclient.domain.options.VirtualApplianceListOptions;
import com.abiquo.apiclient.domain.options.VirtualDatacenterListOptions;
import com.abiquo.apiclient.domain.options.VirtualMachineListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.LinksDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;
import com.abiquo.server.core.cloud.DeviceDto;
import com.abiquo.server.core.cloud.DevicesDto;
import com.abiquo.server.core.cloud.FirewallPoliciesDto;
import com.abiquo.server.core.cloud.FirewallPolicyDto;
import com.abiquo.server.core.cloud.FirewallRulesDto;
import com.abiquo.server.core.cloud.HardwareProfileDto;
import com.abiquo.server.core.cloud.HealthCheckDto;
import com.abiquo.server.core.cloud.HealthChecksDto;
import com.abiquo.server.core.cloud.IPSecVPNDto;
import com.abiquo.server.core.cloud.IPSecVPNsDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressesDto;
import com.abiquo.server.core.cloud.LoadBalancerDto;
import com.abiquo.server.core.cloud.LoadBalancersDto;
import com.abiquo.server.core.cloud.NatIpDto;
import com.abiquo.server.core.cloud.NatIpsDto;
import com.abiquo.server.core.cloud.NatNetworkDto;
import com.abiquo.server.core.cloud.NatNetworksDto;
import com.abiquo.server.core.cloud.RoutingRuleDto;
import com.abiquo.server.core.cloud.RoutingRulesDto;
import com.abiquo.server.core.cloud.SSLCertificateDto;
import com.abiquo.server.core.cloud.SyncVirtualDatacenterDto;
import com.abiquo.server.core.cloud.VPNTunnelStatusDto;
import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualApplianceState;
import com.abiquo.server.core.cloud.VirtualAppliancesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualDatacentersDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineState;
import com.abiquo.server.core.cloud.VirtualMachineStateDto;
import com.abiquo.server.core.cloud.VirtualMachineTaskDto;
import com.abiquo.server.core.cloud.VirtualMachinesDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlanDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlanFlatDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlansDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlansFlatDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.event.EventDto;
import com.abiquo.server.core.event.EventsDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.DatacentersDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionsDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpsDto;
import com.abiquo.server.core.infrastructure.network.IpsBulkCreationDto;
import com.abiquo.server.core.infrastructure.network.NicsDto;
import com.abiquo.server.core.infrastructure.network.PublicIpDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationsDto;
import com.abiquo.server.core.infrastructure.storage.DiskManagementDto;
import com.abiquo.server.core.infrastructure.storage.DisksManagementDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.infrastructure.storage.VolumeManagementDto;
import com.abiquo.server.core.infrastructure.storage.VolumesManagementDto;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TasksDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CloudApi {
    private final RestClient client;

    CloudApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public VirtualDatacenterDto getVirtualDatacenter(int id) {
        return this.client.get("/cloud/virtualdatacenters/" + id, "application/vnd.abiquo.virtualdatacenter+json", VirtualDatacenterDto.class);
    }

    public VirtualDatacenterDto editVirtualDatacenter(VirtualDatacenterDto vdc) {
        return this.client.edit(vdc);
    }

    public Iterable<DatacenterDto> listAllowedDatacenters() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<DatacenterDto> listAllowedDatacenters(AllowedDatacenterListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Iterable<EventDto> listEvents() {
        return this.client.list("/events", "application/vnd.abiquo.events+json", EventsDto.class);
    }

    public Iterable<EventDto> listEvents(EventListOptions options) {
        return this.client.list("/events", options.queryParams(), "application/vnd.abiquo.events+json", EventsDto.class);
    }

    public Iterable<PublicCloudRegionDto> listAllowedPublicCloudRegions() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Iterable<PublicCloudRegionDto> listAllowedPublicCloudRegions(AllowedPublicCloudRegionListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters() {
        return this.client.list("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters(VirtualDatacenterListOptions options) {
        return this.client.list("/cloud/virtualdatacenters", options.queryParams(), "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("externalips").getHref(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc, ExternalIpListOptions options) {
        return this.client.list(vdc.searchLink("externalips").getHref(), options.queryParams(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc, VirtualApplianceListOptions options) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), options.queryParams(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public VirtualApplianceDto getVirtualAppliance(int idVdc, int idVapp) {
        return this.client.get(String.format("%s/%s/virtualappliances/%s", "/cloud/virtualdatacenters", idVdc, idVapp), "application/vnd.abiquo.virtualappliance+json", VirtualApplianceDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp, VirtualMachineListOptions options) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public VLANNetworkDto getPrivateNetwork(VirtualDatacenterDto vdc, int idNetwork) {
        return this.client.get(vdc.searchLink("privatenetworks").getHref() + "/" + idNetwork, "application/vnd.abiquo.vlan+json", VLANNetworkDto.class);
    }

    public Iterable<VMNetworkConfigurationDto> listNetworkConfigurations(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("configurations").getHref(), "application/vnd.abiquo.virtualmachinenetworkconfigurations+json", VMNetworkConfigurationsDto.class);
    }

    public VirtualMachineDto getVirtualMachine(VirtualApplianceDto vapp, int idVm) {
        return this.client.get(vapp.searchLink("virtualmachines").getHref() + "/" + idVm, "application/vnd.abiquo.virtualmachine+json", VirtualMachineDto.class);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, String vlanAddress, String vlanGateway, String vlanName, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.setAddress(vlanAddress);
        vlan.setGateway(vlanGateway);
        vlan.setMask(Integer.valueOf(24));
        vlan.setName(vlanName);
        vlan.setType(NetworkType.INTERNAL);
        return this.createVirtualDatacenter(location, enterprise, name, type, vlan, pollInterval, maxWait, timeUnit);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, VLANNetworkDto vlan, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        Preconditions.checkArgument((location instanceof DatacenterDto || location instanceof PublicCloudRegionDto ? 1 : 0) != 0);
        String mt = location instanceof DatacenterDto ? "application/vnd.abiquo.datacenter+json" : "application/vnd.abiquo.publiccloudregion+json";
        VirtualDatacenterDto vdc = new VirtualDatacenterDto();
        vdc.setName(name);
        vdc.setHypervisorType(type);
        vdc.setVlan(vlan);
        vdc.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), "application/vnd.abiquo.enterprise+json"));
        RESTLink locationLink = (RESTLink)com.google.common.base.Optional.fromNullable((Object)location.searchLink("location")).or(() -> location.searchLink("self"));
        vdc.addLink(Links.create("location", locationLink.getHref(), mt, "datacenter"));
        AsyncTaskDto task = this.client.post("/cloud/virtualdatacenters", "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.virtualdatacenter+json", (SingleResourceTransportDto)vdc, AsyncTaskDto.class);
        task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task)) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), VirtualDatacenterDto.class);
    }

    public void deleteVirtualDatacenter(SingleResourceTransportDto vdc, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        AsyncTaskDto task = this.client.delete(vdc, "application/vnd.abiquo.asynctask+json", AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location) {
        return this.client.post(location.searchLink("ips").getHref(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public void createMultipleIPsExternalNetwork(VLANNetworkDto extNetDto, String starterIP, int nIPs) {
        IpsBulkCreationDto ipsConf = new IpsBulkCreationDto();
        ipsConf.setIp(starterIP);
        ipsConf.setAvailable(true);
        ipsConf.setNumips(nIPs);
        this.client.post(extNetDto.searchLink("ips").getHref(), "application/vnd.abiquo.externalips+json", "application/vnd.abiquo.ipsbulkcreation+json", (SingleResourceTransportDto)ipsConf, ExternalIpsDto.class);
    }

    public PublicIpDto addPublicIpToVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("purchased").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public PublicIpDto releasePublicIpFromVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("topurchase").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public VirtualMachineDto assignPublicIpToVirtualMachine(PublicIpDto ip, PublicCloudRegionDto location, VirtualDatacenterDto vdc, VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        int nics = Iterables.size((Iterable)Iterables.filter((Iterable)vm.getLinks(), Links.isNic()));
        RESTLink nicLink = Links.create("nic" + nics, vdc.searchLink("purchased").getHref() + "/" + ip.getId(), "application/vnd.abiquo.publicip+json");
        vm.addLink(nicLink);
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto createVirtualAppliance(VirtualDatacenterDto vdc, String name) {
        VirtualApplianceDto vapp = new VirtualApplianceDto();
        vapp.setName(name);
        return this.client.post(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliance+json", "application/vnd.abiquo.virtualappliance+json", (SingleResourceTransportDto)vapp, VirtualApplianceDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    private VirtualMachineDto createVirtualMachineWithOtherRelations(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, Optional<FirewallPolicyDto> fw, Optional<HardwareProfileDto> hp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        hp.ifPresent(hwp -> vm.addLink(Links.withRel("hardwareprofile", Links.editOrSelf((SingleResourceTransportDto)hwp))));
        fw.ifPresent(fwp -> vm.addLink(Links.withRel("firewall", fwp.getEditLink())));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto createVirtualMachineWithFirewall(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, FirewallPolicyDto fw, HardwareProfileDto hp) {
        return this.createVirtualMachineWithOtherRelations(template, vapp, Optional.of(fw), Optional.of(hp));
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        vm.addLink(Links.withRel("hardwareprofile", Links.editOrSelf((SingleResourceTransportDto)hp)));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vm.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (!refreshed.getState().isDeployed()) {
            throw new RuntimeException("Deploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vapp.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Deploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vm.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (refreshed.getState().isDeployed()) {
            throw new RuntimeException("Undeploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vapp.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.NOT_DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Undeploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto powerState(VirtualMachineDto vm, VirtualMachineState state, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineStateDto vmState = new VirtualMachineStateDto();
        vmState.setState(state);
        this.client.put(vm.searchLink("state").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinestate+json", (SingleResourceTransportDto)vmState, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (state != refreshed.getState()) {
            throw new RuntimeException("Virtual machine power state '" + state.name() + "' operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto editVirtualMachine(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineDto refreshed = null;
        VirtualMachineState originalState = vm.getState();
        if (vm.getState().isDeployed()) {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, new TypeToken<AcceptedRequestDto<String>>(){
                private static final long serialVersionUID = -6348281615419377868L;
            });
            refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
            if (originalState != refreshed.getState()) {
                throw new RuntimeException("Virtual machine reconfigure operation failed: " + refreshed.getState());
            }
        } else {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm);
            refreshed = this.client.refresh(vm);
        }
        return refreshed;
    }

    public VolumeManagementDto getVolume(VirtualDatacenterDto vdc, int idVolume) {
        return this.client.get(vdc.searchLink("volumes").getHref() + "/" + idVolume, "application/vnd.abiquo.volume+json", VolumeManagementDto.class);
    }

    public VolumeManagementDto createVolume(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier) {
        VolumeManagementDto dto = new VolumeManagementDto();
        dto.setName(name);
        dto.setSizeInMB(sizeInMb);
        dto.addLink(Links.create("tier", tier.searchLink("self").getHref(), "application/vnd.abiquo.tier+json"));
        return this.client.post(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volume+json", "application/vnd.abiquo.volume+json", (SingleResourceTransportDto)dto, VolumeManagementDto.class);
    }

    public TaskDto getTask(VirtualMachineDto vm, String idTask) {
        return this.client.get(vm.searchLink("tasks").getHref() + "/" + idTask, "application/vnd.abiquo.task+json", TaskDto.class);
    }

    public Iterable<TierDto> listTiers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }

    public Iterable<DeviceDto> listDevices(LocationDto location) {
        for (RESTLink link : location.getLinks()) {
            if (!link.getRel().equals("devices") || !link.getType().equals("application/vnd.abiquo.devices+json")) continue;
            return this.client.list(link.getHref(), "application/vnd.abiquo.devices+json", DevicesDto.class);
        }
        return Collections.emptyList();
    }

    public Iterable<VolumeManagementDto> listVolumes(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volumes+json", VolumesManagementDto.class);
    }

    public Iterable<DeviceDto> listDevicesInLocation(LocationDto location) {
        for (RESTLink link : location.getLinks()) {
            if (!link.getRel().equals("devices") || !link.getType().equals("application/vnd.abiquo.devices+json") || !link.getHref().contains("/locations/")) continue;
            return this.client.list(link.getHref(), "application/vnd.abiquo.devices+json", DevicesDto.class);
        }
        return Collections.emptyList();
    }

    public Iterable<LoadBalancerDto> listLoadBalancers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public Iterable<LoadBalancerDto> listLoadBalancers(DeviceDto lbd) {
        return this.client.list(lbd.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public LoadBalancerDto getLoadBalacer(DeviceDto device, int idLoadBalancer) {
        return this.client.get(device.searchLink("loadbalancers").getHref() + "/" + idLoadBalancer, "application/vnd.abiquo.loadbalancer+json", LoadBalancerDto.class);
    }

    public void deleteLoadBalancer(LoadBalancerDto lbd) {
        this.client.delete((SingleResourceTransportDto)lbd);
    }

    public LoadBalancerDto editLoadBalancer(LoadBalancerDto lbd) {
        return this.client.edit(lbd);
    }

    public LoadBalancerDto createLoadBalancer(DeviceDto device, String name, String algorithm, List<RoutingRuleDto> routingRules, List<HealthCheckDto> healthChecks, List<LoadBalancerAddressDto> lbAddresses, List<FirewallPolicyDto> firewalls, com.google.common.base.Optional<VirtualDatacenterDto> vdc, com.google.common.base.Optional<VLANNetworkDto> network) {
        LoadBalancerDto lbd = new LoadBalancerDto();
        lbd.setName(name);
        lbd.setAlgorithm(algorithm);
        lbd.setHealthChecks(new HealthChecksDto());
        lbd.setRoutingRules(new RoutingRulesDto());
        lbd.setLoadBalancerAddresses(new LoadBalancerAddressesDto());
        lbd.getHealthChecks().addAll(healthChecks);
        lbd.getRoutingRules().addAll(routingRules);
        lbd.getLoadBalancerAddresses().addAll(lbAddresses);
        if (vdc.isPresent()) {
            lbd.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)vdc.get())));
        }
        if (network.isPresent()) {
            Preconditions.checkArgument((((VLANNetworkDto)network.get()).getType() == NetworkType.INTERNAL ? 1 : 0) != 0, (Object)"Only internal networks can be assigned to a load balancer");
            lbd.addLink(Links.withRel("privatenetwork", Links.editOrSelf((SingleResourceTransportDto)network.get())));
        }
        for (FirewallPolicyDto fw : firewalls) {
            lbd.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)fw)));
        }
        return this.client.post(device.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancer+json", "application/vnd.abiquo.loadbalancer+json", (SingleResourceTransportDto)lbd, LoadBalancerDto.class);
    }

    public HealthCheckDto createHealthCheck(LoadBalancerDto lbd, String name, String protocol, long intervalInMs, long timeoutInMs, Integer attemps, Integer port, String path) {
        HealthCheckDto healthCheck = new HealthCheckDto();
        healthCheck.setName(name);
        healthCheck.setProtocol(protocol);
        healthCheck.setIntervalInMs(intervalInMs);
        healthCheck.setTimeoutInMs(timeoutInMs);
        healthCheck.setAttempts(attemps.intValue());
        healthCheck.setPort(port.intValue());
        healthCheck.setPath(path);
        return this.client.post(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthcheck+json", "application/vnd.abiquo.healthcheck+json", (SingleResourceTransportDto)healthCheck, HealthCheckDto.class);
    }

    public RoutingRuleDto createRoutingRule(LoadBalancerDto lbd, String protocolIn, String protocolOut, int portIn, int portOut, SSLCertificateDto sslCertificate) {
        RoutingRuleDto routingRule = new RoutingRuleDto();
        routingRule.setPortIn(Integer.valueOf(portIn));
        routingRule.setPortOut(Integer.valueOf(portOut));
        routingRule.setProtocolIn(protocolIn);
        routingRule.setProtocolOut(protocolOut);
        if (sslCertificate != null) {
            routingRule.setSslCertificate(sslCertificate);
        }
        return this.client.post(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrule+json", "application/vnd.abiquo.routingrule+json", (SingleResourceTransportDto)routingRule, RoutingRuleDto.class);
    }

    public Iterable<RoutingRuleDto> listRoutingRules(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrules+json", RoutingRulesDto.class);
    }

    public Iterable<HealthCheckDto> listHealthChecks(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthchecks+json", HealthChecksDto.class);
    }

    public RoutingRulesDto editRoutingRules(RoutingRulesDto routingRules) {
        for (RoutingRuleDto routingRule : routingRules.getCollection()) {
            this.editRoutingRule(routingRule);
        }
        return routingRules;
    }

    public HealthChecksDto editHealthChecks(HealthChecksDto healthChecks) {
        for (HealthCheckDto healthCheck : healthChecks.getCollection()) {
            this.editHealthCheck(healthCheck);
        }
        return healthChecks;
    }

    public void deleteRoutingRule(RoutingRuleDto routingRule) {
        this.client.delete((SingleResourceTransportDto)routingRule);
    }

    public void deleteHealthCheck(HealthCheckDto healthCheck) {
        this.client.delete((SingleResourceTransportDto)healthCheck);
    }

    public RoutingRuleDto editRoutingRule(RoutingRuleDto routingRule) {
        return this.client.edit(routingRule);
    }

    public HealthCheckDto editHealthCheck(HealthCheckDto healthCheck) {
        return this.client.edit(healthCheck);
    }

    public RoutingRuleDto getRoutingRule(LoadBalancerDto lbd, int idRoutingRule) {
        return this.client.get(lbd.searchLink("routingrules").getHref() + "/" + idRoutingRule, "application/vnd.abiquo.routingrule+json", RoutingRuleDto.class);
    }

    public HealthCheckDto getHealthCheck(LoadBalancerDto lbd, int idHealthCheck) {
        return this.client.get(lbd.searchLink("healthchecks").getHref() + "/" + idHealthCheck, "application/vnd.abiquo.healthcheck+json", HealthCheckDto.class);
    }

    public FirewallPolicyDto createFirewallPolicy(String name, String description, DeviceDto firewallDevice, com.google.common.base.Optional<VirtualDatacenterDto> optVdc, boolean isVdcDefault) {
        FirewallPolicyDto firewall = new FirewallPolicyDto();
        firewall.setName(name);
        firewall.setDescription(description);
        if (optVdc.isPresent()) {
            firewall.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)optVdc.get())));
            firewall.setVdcDefault(isVdcDefault);
        }
        return this.client.post(firewallDevice.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicy+json", "application/vnd.abiquo.firewallpolicy+json", (SingleResourceTransportDto)firewall, FirewallPolicyDto.class);
    }

    public Iterable<FirewallPolicyDto> listFirewallPolicies(DeviceDto device) {
        return this.client.list(device.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public Iterable<FirewallPolicyDto> listFirewallPolicies(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public FirewallPolicyDto makeThisFirewallPolicyDefaultForVirtualDatacenter(FirewallPolicyDto fw) {
        return this.client.put(fw.searchLink("defaultfirewallpolicy").getHref(), "application/vnd.abiquo.firewallpolicy+json", FirewallPolicyDto.class);
    }

    public void deleteFirewallPolicies(FirewallPolicyDto firewall) {
        this.client.delete((SingleResourceTransportDto)firewall);
    }

    public FirewallRulesDto addFirewallRules(FirewallPolicyDto firewall, FirewallRulesDto rules) {
        return this.client.put(firewall.searchLink("rules").getHref(), "application/vnd.abiquo.firewallrules+json", "application/vnd.abiquo.firewallrules+json", (SingleResourceTransportDto)rules, FirewallRulesDto.class);
    }

    public VirtualMachineDto addFirewallToVirtualMachine(FirewallPolicyDto firewall, VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)firewall)));
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public NicsDto getNics(VirtualMachineDto vm) {
        return this.client.get(vm.searchLink("nics").getHref(), "application/vnd.abiquo.nics+json", NicsDto.class);
    }

    public VirtualMachineDto cloneVirtualMachine(VirtualMachineDto vm) {
        return this.client.post(vm.searchLink("clone").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachinecloneoptions+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public IPSecVPNDto createIPSecVPN(VirtualDatacenterDto vdc, String name, String remoteEndpoint, String encryptionAlgorithm, boolean perfectForwardSecrecyEnabled, String dhGroup, String authentication, Set<String> remoteNetworks, String presharedKey, com.google.common.base.Optional<RESTLink> localEndpoint, com.google.common.base.Optional<Set<VLANNetworkDto>> localNetworks, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        IPSecVPNDto vpnIPSec = new IPSecVPNDto();
        vpnIPSec.setName(name);
        vpnIPSec.setRemoteEndpoint(remoteEndpoint);
        vpnIPSec.setEncryptionAlgorithm(encryptionAlgorithm);
        vpnIPSec.setPerfectForwardSecrecyEnabled(perfectForwardSecrecyEnabled);
        vpnIPSec.setDhGroup(dhGroup);
        vpnIPSec.setAuthentication(authentication);
        vpnIPSec.setRemoteNetworks(remoteNetworks);
        vpnIPSec.setPresharedKey(presharedKey);
        vpnIPSec.addLink(Links.withRel("localnetwork", vdc.getVlan().getEditLink()));
        if (localEndpoint.isPresent()) {
            vpnIPSec.addLink(Links.withRel("localendpoint", (RESTLink)localEndpoint.get()));
        }
        if (localNetworks.isPresent()) {
            for (VLANNetworkDto vlan : (Set)localNetworks.get()) {
                vpnIPSec.addLink(Links.withRel("localnetwork", vlan.getEditLink()));
            }
        }
        AsyncTaskDto task = this.client.post(vdc.searchLink("vpns").getHref(), "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.vpnipsec+json", (SingleResourceTransportDto)vpnIPSec, AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), IPSecVPNDto.class);
    }

    public Iterable<IPSecVPNDto> listIPSecVPN(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("vpns").getHref(), "application/vnd.abiquo.vpnsipsec+json", IPSecVPNsDto.class);
    }

    public IPSecVPNDto getIPSecVPN(int idVdc, int idVpn) {
        return this.client.get(String.format("%s/%s/vpns/%s", "/cloud/virtualdatacenters", idVdc, idVpn), "application/vnd.abiquo.vpnipsec+json", IPSecVPNDto.class);
    }

    public void deleteIPSecVPN(SingleResourceTransportDto vpn, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        AsyncTaskDto task = this.client.delete(vpn, "application/vnd.abiquo.asynctask+json", AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
    }

    public IPSecVPNDto editIPSecVPNDto(IPSecVPNDto vpn, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        RESTLink link = vpn.getEditLink();
        AsyncTaskDto task = this.client.put(link.getHref(), "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.vpnipsec+json", (SingleResourceTransportDto)vpn, AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), IPSecVPNDto.class);
    }

    public VPNTunnelStatusDto checkTunnelStatusOfAnIPSecVPN(IPSecVPNDto vpn) {
        return this.client.get(vpn.searchLink("status"), VPNTunnelStatusDto.class);
    }

    public Iterable<NatNetworkDto> listNatNetworksInADevice(DeviceDto device) {
        return this.client.list(device.searchLink("natnetworks").getHref(), "application/vnd.abiquo.natnetworks+json", NatNetworksDto.class);
    }

    public Iterable<NatIpDto> listNatIPsInVirtualDatacenter(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.getEditLink().getHref() + "/action/natips", "application/vnd.abiquo.natips+json", NatIpsDto.class);
    }

    public NatIpDto assignNatIPToVirtualDatacenter(NatNetworkDto natNW, VirtualDatacenterDto vdc) {
        LinksDto links = new LinksDto();
        links.addLink(Links.create("virtualdatacenter", vdc.getEditLink().getHref(), vdc.getEditLink().getType()));
        return this.client.post(natNW.searchLink("ips").getHref(), "application/vnd.abiquo.natip+json", "application/vnd.abiquo.links+json", (SingleResourceTransportDto)links, NatIpDto.class);
    }

    public Iterable<FirewallPolicyDto> syncFirewallPolicies(VirtualDatacenterDto vdc) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("source", "REMOTE");
        return this.client.list(vdc.searchLink("firewalls").getHref(), queryParams, "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public VirtualMachineDto assignIpToVirtualMachine(VirtualMachineDto vm, VLANNetworkDto vlan, int pollInterval, int maxWait, TimeUnit timeUnit) {
        int nics = Iterables.size((Iterable)Iterables.filter((Iterable)vm.getLinks(), Links.isNic()));
        RESTLink ipLink = Links.create("nic" + nics, vlan.searchLink("ips").getHref(), "application/vnd.abiquo.privateip+json", "newIP");
        vm.addLink(ipLink);
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public void syncVirtualDatacenter(ApiClient api, VirtualDatacenterDto vdc, int syncVDCPollInterval, int syncVDCWaitTime, TimeUnit syncVDCTimeUnit) {
        SyncVirtualDatacenterDto sync = new SyncVirtualDatacenterDto();
        sync.addLink(vdc.searchLink("location"));
        sync.setProviderId(vdc.getProviderId());
        AcceptedRequestDto accepted = api.getClient().post("/cloud/virtualdatacenters", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.syncvirtualdatacenter+json", (SingleResourceTransportDto)sync, AcceptedRequestDto.class);
        RESTLink taskLink = accepted.searchLink("status");
        TaskDto task = api.getClient().get(taskLink, TaskDto.class);
        this.client.waitForTask(task, syncVDCPollInterval, syncVDCWaitTime, syncVDCTimeUnit);
    }

    public DiskManagementDto createHardDisk(VirtualDatacenterDto vdc, DiskManagementDto disk) {
        return this.client.post(vdc.searchLink("disks").getHref(), "application/vnd.abiquo.harddisk+json", "application/vnd.abiquo.harddisk+json", (SingleResourceTransportDto)disk, DiskManagementDto.class);
    }

    public Iterable<DiskManagementDto> listHardDisks(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("harddisks"), DisksManagementDto.class);
    }

    public VirtualMachineDto detachVolume(VirtualMachineDto vm, VolumeManagementDto vol) {
        return this.detachVolume(vm, vol, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto detachVolume(VirtualMachineDto vm, VolumeManagementDto vol, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.getLinks().stream().filter(l -> "application/vnd.abiquo.volume+json".equals(l.getType()) && l.getHref().equals(vol.getEditLink().getHref())).findFirst().ifPresent(vm.getLinks()::remove);
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto detachAllExternalIPs(VirtualMachineDto vm) {
        return this.detachAllExternalIPs(vm, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto detachAllExternalIPs(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.getLinks().removeIf(l -> l.getType().equals("application/vnd.abiquo.externalip+json") || l.getRel().equals("network_configuration"));
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto attachVolume(VirtualMachineDto vm, VolumeManagementDto vol) {
        return this.attachVolume(vm, vol, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto attachVolume(VirtualMachineDto vm, VolumeManagementDto vol, int pollInterval, int maxWait, TimeUnit timeUnit) {
        List disks = StreamSupport.stream(vm.getLinks().spliterator(), false).filter(l -> l.getRel().startsWith("disk")).collect(Collectors.toList());
        int diskNumber = disks.size();
        vm.addLink(Links.withRel("disk" + diskNumber, Links.editOrSelf((SingleResourceTransportDto)vol)));
        return this.editVirtualMachine(vm, pollInterval, maxWait, timeUnit);
    }

    public ActionPlanDto createActionPlan(ActionPlanDto ap) {
        return this.client.post("/cloud/actionplans", "application/vnd.abiquo.actionplan+json", "application/vnd.abiquo.actionplan+json", (SingleResourceTransportDto)ap, ActionPlanDto.class);
    }

    public Iterable<ActionPlanDto> listActionPlans() {
        return this.client.list("/cloud/actionplans", "application/vnd.abiquo.actionplans+json", ActionPlansDto.class);
    }

    public Iterable<ActionPlanFlatDto> listActionPlansFlat() {
        return this.client.list("/cloud/actionplans", "application/vnd.abiquo.actionplansflat+json", ActionPlansFlatDto.class);
    }

    public ActionPlanDto editActionPlan(ActionPlanDto ap) {
        return this.client.edit(ap);
    }

    public void deleteActionPlan(ActionPlanDto ap) {
        this.client.delete((SingleResourceTransportDto)ap);
    }

    public Iterable<TaskDto> listTasksInActionPlan(ActionPlanDto ap) {
        return this.client.list(ap.getEditLink().getHref() + "tasks", "application/vnd.abiquo.tasks+json", TasksDto.class);
    }

    public TaskDto executeActionPlanAndGetTask(ActionPlanDto ap, int pollInterval, int maxWait, TimeUnit timeUnit) {
        AcceptedRequestDto<String> acceptedRequest = this.client.post(ap.getEditLink().getHref() + "/action/execute", "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -233229364804015778L;
        });
        return this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
    }

    public boolean executeActionPlanAndWait(ActionPlanDto ap, int pollInterval, int maxWait, TimeUnit timeUnit) {
        TaskDto task = this.executeActionPlanAndGetTask(ap, pollInterval, maxWait, timeUnit);
        return this.client.waitForSuccessfulTaskFinalization(task, pollInterval, maxWait, timeUnit);
    }
}

