/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.options.ListOptions;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.cloud.DeviceTypeDto;
import com.abiquo.server.core.cloud.DeviceTypesDto;
import com.abiquo.server.core.cloud.HypervisorTypeDto;
import com.abiquo.server.core.cloud.HypervisorTypesDto;
import com.abiquo.server.core.cloud.RegionDto;
import com.abiquo.server.core.cloud.RegionsDto;
import com.abiquo.server.core.enterprise.PrivilegeDto;
import com.abiquo.server.core.enterprise.PrivilegesDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.pricing.CostCodeDto;
import com.abiquo.server.core.pricing.CostCodesDto;
import com.abiquo.server.core.pricing.CurrenciesDto;
import com.abiquo.server.core.pricing.CurrencyDto;
import com.abiquo.server.core.pricing.PricingTemplateDto;
import com.abiquo.server.core.pricing.PricingTemplatesDto;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class ConfigApi {
    private final RestClient client;

    ConfigApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public HypervisorTypeDto getHypervisorType(String type) {
        return this.client.get(String.format("%s/%s", "/config/hypervisortypes", type), "application/vnd.abiquo.hypervisortype+json", HypervisorTypeDto.class);
    }

    public HypervisorTypeDto getHypervisorType(LocationDto location) {
        return this.client.get(location.searchLink("hypervisortype").getHref(), "application/vnd.abiquo.hypervisortype+json", HypervisorTypeDto.class);
    }

    public Iterable<HypervisorTypeDto> getHypervisorTypes() {
        return this.client.list("/config/hypervisortypes", "application/vnd.abiquo.hypervisortypes+json", HypervisorTypesDto.class);
    }

    public DeviceTypeDto getDeviceType(String type) {
        return this.client.get(String.format("%s/%s", "/config/devicetypes", type), "application/vnd.abiquo.devicetype+json", DeviceTypeDto.class);
    }

    public Iterable<DeviceTypeDto> getDeviceTypes() {
        return this.client.list("/config/devicetypes", "application/vnd.abiquo.devicetypes+json", DeviceTypesDto.class);
    }

    public Iterable<RegionDto> getRegions(String hypervisorType) {
        return this.client.list(this.getHypervisorType(hypervisorType).searchLink("regions").getHref(), "application/vnd.abiquo.regions+json", RegionsDto.class);
    }

    public Optional<RegionDto> getRegion(String hypervisorType, String region) {
        return StreamSupport.stream(this.getRegions(hypervisorType).spliterator(), false).filter(r -> r.getProviderId().equals(region)).findFirst();
    }

    public Iterable<RegionDto> getDynamicRegions(String hypervisorType, String identity, String credential, String endpoint) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Abiquo-PCR-Identity", identity);
        headers.put("X-Abiquo-PCR-Credential", credential);
        headers.put("X-Abiquo-PCR-Endpoint", endpoint);
        return this.client.list(this.getHypervisorType(hypervisorType).searchLink("regions").getHref(), "application/vnd.abiquo.regions+json", RegionsDto.class, headers);
    }

    public Optional<RegionDto> getDynamicRegion(String hypervisorType, String region, String identity, String credential, String endpoint) {
        return StreamSupport.stream(this.getDynamicRegions(hypervisorType, identity, credential, endpoint).spliterator(), false).filter(r -> r.getName().equals(region)).findFirst();
    }

    public CostCodeDto createCostcode(CostCodeDto costCode) {
        return this.client.post("/config/costcodes", "application/vnd.abiquo.costcode+json; version=4.7", "application/vnd.abiquo.costcode+json; version=4.7", (SingleResourceTransportDto)costCode, CostCodeDto.class);
    }

    public Iterable<CostCodeDto> listCostcodes(ListOptions options) {
        return this.client.list("/config/costcodes", options.queryParams(), "application/vnd.abiquo.costcodes+json", CostCodesDto.class);
    }

    public Iterable<PrivilegeDto> listPrivileges() {
        return this.client.list("/config/privileges", "application/vnd.abiquo.privileges+json", PrivilegesDto.class);
    }

    public PricingTemplateDto createPricingTemplate(PricingTemplateDto pricingTemplate) {
        return this.client.post("/config/pricingtemplates", "application/vnd.abiquo.pricingtemplate+json", "application/vnd.abiquo.pricingtemplate+json", (SingleResourceTransportDto)pricingTemplate, PricingTemplateDto.class);
    }

    public Iterable<PricingTemplateDto> listPricingTemplates() {
        return this.client.list("/config/pricingtemplates", "application/vnd.abiquo.pricingtemplates+json", PricingTemplatesDto.class);
    }

    public Iterable<CurrencyDto> listCurrencies() {
        return this.client.list("/config/currencies", "application/vnd.abiquo.currencies+json", CurrenciesDto.class);
    }
}

