/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.ApiClient;
import com.abiquo.apiclient.auth.Authentication;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.PageIterator;
import com.abiquo.apiclient.domain.exception.AbiquoException;
import com.abiquo.apiclient.domain.exception.AuthorizationException;
import com.abiquo.apiclient.domain.exception.DataBaseException;
import com.abiquo.apiclient.domain.exception.HttpException;
import com.abiquo.apiclient.domain.options.BaseOptions;
import com.abiquo.apiclient.interceptors.AuthenticationInterceptor;
import com.abiquo.apiclient.json.Json;
import com.abiquo.apiclient.util.LogUtils;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.model.transport.WrapperDto;
import com.abiquo.model.transport.error.ErrorDto;
import com.abiquo.model.transport.error.ErrorsDto;
import com.abiquo.model.transport.error.LimitExceededErrorDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;
import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualApplianceState;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineState;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TaskState;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Uninterruptibles;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RestClient {
    private final OkHttpClient client;
    private final Json json = new Json();
    private final String baseURL;
    private final String apiVersion;
    private final RequestBody emptyRequestBody;

    RestClient(Authentication authentication, String baseURL, String apiVersion, ApiClient.SSLConfiguration sslConfiguration) {
        this.baseURL = (String)Preconditions.checkNotNull((Object)baseURL, (Object)"baseURL cannot be null");
        this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion, (Object)"apiVersion cannot be null");
        this.emptyRequestBody = RequestBody.create(null, (byte[])new byte[0]);
        this.client = new OkHttpClient();
        this.client.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.client.setWriteTimeout(0L, TimeUnit.MILLISECONDS);
        this.client.setConnectTimeout(0L, TimeUnit.MILLISECONDS);
        this.client.networkInterceptors().add(new AuthenticationInterceptor(authentication, this));
        if (sslConfiguration != null) {
            this.client.setHostnameVerifier(sslConfiguration.hostnameVerifier());
            this.client.setSslSocketFactory(sslConfiguration.sslContext().getSocketFactory());
        }
    }

    public OkHttpClient rawClient() {
        return this.client;
    }

    public Json json() {
        return this.json;
    }

    public <T extends SingleResourceTransportDto> T edit(T dto) {
        RESTLink link = (RESTLink)Preconditions.checkNotNull((Object)dto.getEditLink(), (Object)"The given object does not have an edit link");
        Class<?> clazz = dto.getClass();
        return (T)this.put(link.getHref(), link.getType(), link.getType(), dto, clazz);
    }

    public void delete(SingleResourceTransportDto dto) {
        RESTLink link = (RESTLink)Preconditions.checkNotNull((Object)Links.editOrSelf(dto), (Object)"The given object does not have an edit/self link");
        this.delete(link.getHref());
    }

    public <T extends SingleResourceTransportDto> T refresh(T dto) {
        RESTLink link = Links.editOrSelf(dto);
        Class<?> clazz = dto.getClass();
        Preconditions.checkNotNull((Object)link, (Object)"The given object does not have an edit/self link");
        return (T)this.get(link.getHref(), link.getType(), clazz);
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(RESTLink link, Class<W> clazz) {
        return PageIterator.flatten(this, (WrapperDto)this.get(link, clazz));
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(String uri, String accept, Class<W> returnClass) {
        return PageIterator.flatten(this, (WrapperDto)this.get(uri, accept, returnClass));
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(String uri, String accept, TypeToken<W> returnType) {
        return PageIterator.flatten(this, (WrapperDto)this.get(uri, accept, returnType));
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(String uri, Map<String, Object> queryParams, String accept, Class<W> returnClass) {
        return PageIterator.flatten(this, (WrapperDto)this.get(uri, queryParams, accept, returnClass));
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(String uri, String accept, Class<W> returnClass, Map<String, String> headers) {
        return PageIterator.flatten(this, (WrapperDto)this.get(uri, accept, returnClass, headers));
    }

    public <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> list(String uri, Map<String, Object> queryParams, String accept, TypeToken<W> returnType) {
        return PageIterator.flatten(this, (WrapperDto)this.get(uri, queryParams, accept, returnType));
    }

    public <T extends SingleResourceTransportDto> T get(RESTLink link, Class<T> clazz) {
        return this.get(link.getHref(), link.getType(), clazz);
    }

    public <T extends SingleResourceTransportDto> T get(String uri, String accept, Class<T> returnClass) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).get().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T get(String uri, String accept, TypeToken<T> returnType) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).get().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T get(String uri, String accept, Class<T> returnClass, Map<String, String> headers) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(this.absolute(uri));
            headers.entrySet().stream().forEach(h -> requestBuilder.addHeader((String)h.getKey(), (String)h.getValue()));
            Request request = requestBuilder.addHeader("Accept", this.withVersion(accept)).get().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T get(String uri, Map<String, Object> queryParams, String accept, Class<T> returnClass) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri) + "?" + this.queryLine(queryParams)).addHeader("Accept", this.withVersion(accept)).get().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T get(String uri, Map<String, Object> queryParams, String accept, TypeToken<T> returnType) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri) + "?" + this.queryLine(queryParams)).addHeader("Accept", this.withVersion(accept)).get().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public String getAsString(String uri, String accept) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).get().build();
            return this.execute(request, String.class);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T delete(SingleResourceTransportDto dto, String accept, Class<T> returnClass) {
        RESTLink link = (RESTLink)Preconditions.checkNotNull((Object)Links.editOrSelf(dto), (Object)"The given object does not have an edit/self link");
        try {
            Request request = new Request.Builder().url(this.absolute(link.getHref())).addHeader("Accept", this.withVersion(accept)).delete().build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public void delete(String uri) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).delete().build();
            this.execute(request, (Class)null);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, String contentType, SingleResourceTransportDto body, Class<T> returnClass) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).post(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, String contentType, SingleResourceTransportDto body, Class<T> returnClass, Map<String, String> headers) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request.Builder requestBuilder = new Request.Builder().url(this.absolute(uri));
            headers.entrySet().stream().forEach(h -> requestBuilder.addHeader((String)h.getKey(), (String)h.getValue()));
            Request request = requestBuilder.addHeader("Accept", this.withVersion(accept)).post(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, String contentType, SingleResourceTransportDto body, TypeToken<T> returnType) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).post(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, Class<T> returnClass) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).post(this.emptyRequestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, String contentType, String body, Class<T> returnClass) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)body);
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).post(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public Response multipartPost(String url, String bodyName, String body, String fileName, File file) {
        OkHttpClient multipartClient = this.client.clone();
        try {
            RequestBody jsonPart = RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=UTF-8"), (String)body);
            RequestBody filePart = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream; charset=ISO-8859-1"), (File)file);
            RequestBody requestBody = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + bodyName + "\""}), jsonPart).addFormDataPart(fileName, file.getName(), filePart).build();
            Request request = new Request.Builder().url(this.absolute(url)).post(requestBody).build();
            Response response = multipartClient.newCall(request).execute();
            this.checkResponse(request, response, response.body().string());
            return response;
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T post(String uri, String accept, TypeToken<T> returnType) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).post(this.emptyRequestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T put(String uri, String accept, String contentType, SingleResourceTransportDto body, Class<T> returnClass) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).put(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public void putAction(String uri, String contentType, SingleResourceTransportDto body) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request request = new Request.Builder().url(this.absolute(uri)).put(requestBody).build();
            this.execute(request, (Class)null);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T put(String uri, String accept, Class<T> returnClass) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).put(this.emptyRequestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnClass));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T put(String uri, String accept, TypeToken<T> returnType) {
        try {
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).put(this.emptyRequestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public <T extends SingleResourceTransportDto> T put(String uri, String accept, String contentType, SingleResourceTransportDto body, TypeToken<T> returnType) {
        try {
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)this.json.write(body));
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).put(requestBody).build();
            return (T)((SingleResourceTransportDto)this.execute(request, returnType));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public void put(String uri, String accept, String contentType, SingleResourceTransportDto body) {
        try {
            String rawBody = this.json.write(body);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.withVersion(contentType)), (String)rawBody);
            Request request = new Request.Builder().url(this.absolute(uri)).addHeader("Accept", this.withVersion(accept)).put(requestBody).build();
            this.execute(request, (Class)null);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private String absolute(String path) {
        try {
            new URL(path);
        }
        catch (MalformedURLException e) {
            return this.baseURL + (path.startsWith("/") ? path : "/" + path);
        }
        return path;
    }

    private String withVersion(String mediaType) {
        return mediaType.contains("version=") ? mediaType : mediaType + "; version=" + this.apiVersion;
    }

    private String queryLine(Map<String, Object> queryParams) {
        TreeMap<String, Object> queryParamsSorted = new TreeMap<String, Object>(queryParams);
        return Joiner.on((char)'&').withKeyValueSeparator("=").join(Maps.transformValues(queryParamsSorted, input -> BaseOptions.urlEncode(input.toString())));
    }

    public TaskDto waitForTask(AcceptedRequestDto<?> acceptedRequest, int pollInterval, int maxWait, TimeUnit timeUnit) {
        RESTLink status = acceptedRequest.getStatusLink();
        return this.waitForTask(status, pollInterval, maxWait, timeUnit);
    }

    public TaskDto waitForTask(TaskDto taskDto, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.waitForTask(taskDto.searchLink("self"), pollInterval, maxWait, timeUnit);
    }

    private TaskDto waitForTask(RESTLink restLink, int pollInterval, int maxWait, TimeUnit timeUnit) {
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < (long)maxWait) {
            TaskDto updatedTask = this.get(restLink.getHref(), "application/vnd.abiquo.task+json", TaskDto.class);
            switch (updatedTask.getState()) {
                case FINISHED_SUCCESSFULLY: 
                case FINISHED_UNSUCCESSFULLY: 
                case ABORTED: 
                case ACK_ERROR: 
                case CANCELLED: {
                    return updatedTask;
                }
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        throw new RuntimeException("Task did not complete in the configured timeout");
    }

    public VirtualMachineDto waitUntilUnlocked(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < (long)maxWait) {
            VirtualMachineDto refreshed = this.refresh(vm);
            if (!VirtualMachineState.LOCKED.equals((Object)refreshed.getState())) {
                return refreshed;
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        throw new RuntimeException("Virtual machine did not reach the desired state in the configured timeout");
    }

    public VirtualApplianceDto waitUntilUnlocked(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < (long)maxWait) {
            VirtualApplianceDto refreshed = this.refresh(vapp);
            if (!VirtualApplianceState.LOCKED.equals((Object)refreshed.getState())) {
                return refreshed;
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        throw new RuntimeException("Virtual appliance did not reach the desired state in the configured timeout");
    }

    private <T> T execute(Request request, Class<T> resultClass) throws IOException {
        LogUtils.logRequest(request);
        Response response = this.client.newCall(request).execute();
        String responseBody = response.body().string();
        LogUtils.logResponse(response, responseBody);
        try {
            this.checkResponse(request, response, responseBody);
        }
        catch (DataBaseException dbEx) {
            return this.execute(request, resultClass);
        }
        if (!Strings.isNullOrEmpty((String)responseBody) && resultClass != null) {
            if (String.class.equals(resultClass)) {
                return resultClass.cast(responseBody);
            }
            return this.json.read(responseBody, resultClass);
        }
        return null;
    }

    private <T> T execute(Request request, TypeToken<T> returnType) throws IOException {
        LogUtils.logRequest(request);
        Response response = this.client.newCall(request).execute();
        String responseBody = response.body().string();
        LogUtils.logResponse(response, responseBody);
        try {
            this.checkResponse(request, response, responseBody);
        }
        catch (DataBaseException dbEx) {
            return this.execute(request, returnType);
        }
        return !Strings.isNullOrEmpty((String)responseBody) && returnType != null ? (T)this.json.read(responseBody, returnType) : null;
    }

    private void checkResponse(Request request, Response response, String responseBody) throws IOException {
        int responseCode = response.code();
        if (responseCode == 401 || responseCode == 403) {
            throw new AuthorizationException(responseCode, response.message());
        }
        if (responseCode >= 400) {
            if (responseBody == null) {
                throw new HttpException(responseCode, response.message());
            }
            try {
                if (response.header("Content-Type").equals("application/vnd.abiquo.limiterror+json")) {
                    LimitExceededErrorDto error = this.json.read(responseBody, LimitExceededErrorDto.class);
                    throw new AbiquoException(responseCode, (ErrorDto)error);
                }
                ErrorsDto errors = this.json.read(responseBody, ErrorsDto.class);
                if (errors.getCollection().stream().anyMatch(err -> "DB-0".equals(err.getCode()))) {
                    throw new DataBaseException(responseCode, errors);
                }
                throw new AbiquoException(responseCode, errors);
            }
            catch (Exception ex) {
                Throwables.propagateIfInstanceOf((Throwable)ex, AbiquoException.class);
                throw new HttpException(responseCode, response.message() + ". Body: " + responseBody);
            }
        }
    }

    public AsyncTaskDto waitForAsyncTaskFinalization(AsyncTaskDto taskDto, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException {
        String selfHref = taskDto.searchLink("self").getHref();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < maxWait) {
            AsyncTaskDto task = this.get(selfHref, "application/vnd.abiquo.asynctask+json", AsyncTaskDto.class);
            if (task.isFinished()) {
                return task;
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        throw new TimeoutException("Task did not complete in the configured timeout");
    }

    public boolean waitForSuccessfulTaskFinalization(TaskDto task, int pollInterval, int maxWait, TimeUnit timeUnit) {
        String selfHref = task.searchLink("self").getHref();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(timeUnit) < (long)maxWait) {
            TaskDto t = this.get(selfHref, "application/vnd.abiquo.task+json", TaskDto.class);
            if (TaskState.FINISHED_SUCCESSFULLY.equals((Object)t.getState())) {
                return true;
            }
            Uninterruptibles.sleepUninterruptibly((long)pollInterval, (TimeUnit)timeUnit);
        }
        return false;
    }
}

