/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain.options;

import com.abiquo.apiclient.domain.options.BaseOptions;
import com.abiquo.apiclient.domain.options.ListOptions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class EventListOptions
extends BaseOptions {
    private static String dateToISO8601String(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    protected EventListOptions(Map<String, Object> queryParams) {
        super(queryParams);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ListOptions.BaseOptionsBuilder<Builder> {
        private String datefrom;
        private String dateto;
        private String entitytype;
        private String actiontype;
        private String entityname;
        private String severity;
        private String enterprisename;
        private String username;
        private String context;

        public Builder datefrom(Date datefrom) {
            this.datefrom = EventListOptions.dateToISO8601String(datefrom);
            return this.self();
        }

        public Builder dateto(Date dateto) {
            this.dateto = EventListOptions.dateToISO8601String(dateto);
            return this.self();
        }

        public Builder entitytype(String entitytype) {
            this.entitytype = entitytype;
            return this.self();
        }

        public Builder actiontype(String actiontype) {
            this.actiontype = actiontype;
            return this.self();
        }

        public Builder entityname(String entityname) {
            this.entityname = entityname;
            return this.self();
        }

        public Builder severity(String severity) {
            this.severity = severity;
            return this.self();
        }

        public Builder enterprisename(String enterprisename) {
            this.enterprisename = enterprisename;
            return this.self();
        }

        public Builder context(String context) {
            this.context = context;
            return this.self();
        }

        public Builder username(String username) {
            this.username = username;
            return this.self();
        }

        @Override
        protected Map<String, Object> buildParameters() {
            Map<String, Object> params = super.buildParameters();
            BaseOptions.putIfPresent("datefrom", this.datefrom, params);
            BaseOptions.putIfPresent("dateto", this.dateto, params);
            BaseOptions.putIfPresent("entitytype", this.entitytype, params);
            BaseOptions.putIfPresent("actiontype", this.actiontype, params);
            BaseOptions.putIfPresent("entityname", this.entityname, params);
            BaseOptions.putIfPresent("severity", this.severity, params);
            BaseOptions.putIfPresent("enterprisename", this.enterprisename, params);
            BaseOptions.putIfPresent("username", this.username, params);
            BaseOptions.putIfPresent("context", this.context, params);
            return params;
        }

        @Override
        public EventListOptions build() {
            return new EventListOptions(this.buildParameters());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

