/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.CloudApi;
import com.abiquo.apiclient.ConfigApi;
import com.abiquo.apiclient.EnterpriseApi;
import com.abiquo.apiclient.InfrastructureApi;
import com.abiquo.apiclient.MetricsApi;
import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.TemplatesApi;
import com.abiquo.apiclient.auth.Authentication;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class ApiClient {
    private final RestClient client;
    private final EnterpriseApi enterpriseApi;
    private final InfrastructureApi infrastructureApi;
    private final CloudApi cloudApi;
    private final TemplatesApi templatesApi;
    private final ConfigApi configApi;
    private final MetricsApi metricsApi;
    private final String endpoint;
    private final Authentication authentication;
    private final String version;
    private final SSLConfiguration sslConfiguration;

    private ApiClient(String endpoint, Authentication authentication, String version, SSLConfiguration sslConfiguration) {
        this.client = new RestClient(authentication, endpoint, version, sslConfiguration);
        this.enterpriseApi = new EnterpriseApi(this.client);
        this.infrastructureApi = new InfrastructureApi(this.client);
        this.cloudApi = new CloudApi(this.client);
        this.templatesApi = new TemplatesApi(this.client);
        this.configApi = new ConfigApi(this.client);
        this.metricsApi = new MetricsApi(this.client);
        this.endpoint = endpoint;
        this.authentication = authentication;
        this.version = version;
        this.sslConfiguration = sslConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ApiClient.builder().endpoint(this.endpoint).authentication(this.authentication).version(this.version).sslConfiguration(this.sslConfiguration);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public RestClient getClient() {
        return this.client;
    }

    public EnterpriseApi getEnterpriseApi() {
        return this.enterpriseApi;
    }

    public InfrastructureApi getInfrastructureApi() {
        return this.infrastructureApi;
    }

    public CloudApi getCloudApi() {
        return this.cloudApi;
    }

    public TemplatesApi getTemplatesApi() {
        return this.templatesApi;
    }

    public ConfigApi getConfigApi() {
        return this.configApi;
    }

    public MetricsApi getMetricsApi() {
        return this.metricsApi;
    }

    public static interface SSLConfiguration {
        public SSLContext sslContext();

        public HostnameVerifier hostnameVerifier();
    }

    public static class Builder {
        private String endpoint;
        private Authentication authentication;
        private String version = "5.1";
        private SSLConfiguration sslConfiguration;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder sslConfiguration(SSLConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public ApiClient build() {
            return new ApiClient(this.endpoint, this.authentication, this.version, this.sslConfiguration);
        }
    }
}

