/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain;

import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.google.common.base.Predicate;

public final class Links {
    public static RESTLink create(String rel, String href, String type) {
        RESTLink link = new RESTLink(rel, href);
        link.setType(type);
        return link;
    }

    public static RESTLink create(String rel, String href, String type, String title) {
        RESTLink link = Links.create(rel, href, type);
        link.setTitle(title);
        return link;
    }

    public static RESTLink withRel(String newRel, RESTLink source) {
        RESTLink link = Links.create(newRel, source.getHref(), source.getType());
        link.setTitle(source.getTitle());
        return link;
    }

    public static RESTLink editOrSelf(SingleResourceTransportDto dto) {
        RESTLink link = dto.getEditLink();
        if (link == null) {
            link = dto.searchLink("self");
        }
        return link;
    }

    public static Predicate<RESTLink> isTemplateDisk() {
        return new Predicate<RESTLink>(){

            public boolean apply(RESTLink input) {
                return input.getRel().startsWith("disk") && !input.getRel().equalsIgnoreCase("disks");
            }
        };
    }

    public static Predicate<RESTLink> isNic() {
        return new Predicate<RESTLink>(){

            public boolean apply(RESTLink input) {
                return input.getRel().matches("^nic[0-9]+$");
            }
        };
    }

    public static Predicate<RESTLink> isDisk() {
        return new Predicate<RESTLink>(){

            public boolean apply(RESTLink input) {
                return input.getRel().matches("^disk[0-9]+$");
            }
        };
    }

    private Links() {
        throw new AssertionError((Object)"Constant class. Clients shouldn't instantiate it directly.");
    }
}

