/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain;

import com.abiquo.apiclient.RestClient;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.model.transport.WrapperDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class PageIterator<T extends WrapperDto<? extends SingleResourceTransportDto>>
extends AbstractIterator<T> {
    private final RestClient api;
    private T currentPage;
    private boolean unread;

    private PageIterator(RestClient api, T initialPage) {
        this.api = (RestClient)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
        this.currentPage = (WrapperDto)Preconditions.checkNotNull(initialPage, (Object)"initialPage cannot be null");
        this.unread = true;
    }

    protected T computeNext() {
        if (this.unread) {
            try {
                T t = this.currentPage;
                return t;
            }
            finally {
                this.unread = false;
            }
        }
        RESTLink next = this.currentPage.searchLink("next");
        if (next == null) {
            return (T)((WrapperDto)this.endOfData());
        }
        this.currentPage = (WrapperDto)this.api.get(next.getHref(), this.currentPage.getBaseMediaType(), this.currentPage.getClass());
        return this.currentPage;
    }

    public static <T extends SingleResourceTransportDto, W extends WrapperDto<T>> Iterable<T> flatten(RestClient api, W dto) {
        return new AdvancingIterable(api, dto, null);
    }

    /* synthetic */ PageIterator(RestClient x0, WrapperDto x1, 1 x2) {
        this(x0, x1);
    }

    public static class AdvancingIterable<T extends SingleResourceTransportDto, W extends WrapperDto<T>>
    implements Iterable<T> {
        private final RestClient api;
        private final W initialPage;

        private AdvancingIterable(RestClient api, W initialPage) {
            this.api = (RestClient)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.initialPage = (WrapperDto)Preconditions.checkNotNull(initialPage, (Object)"initialPage cannot be null");
        }

        public int size() {
            return this.initialPage.getTotalSize();
        }

        @Override
        public Iterator<T> iterator() {
            final PageIterator pageIterator = new PageIterator(this.api, (WrapperDto)this.initialPage, null);
            return Iterators.concat((Iterator)new AbstractIterator<Iterator<T>>(){

                protected Iterator<T> computeNext() {
                    return pageIterator.hasNext() ? ((WrapperDto)pageIterator.next()).getCollection().iterator() : (Iterator)this.endOfData();
                }
            });
        }

        /* synthetic */ AdvancingIterable(RestClient x0, WrapperDto x1, 1 x2) {
            this(x0, x1);
        }
    }
}

