/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.interceptors;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.auth.Authentication;
import com.abiquo.apiclient.auth.BasicAuthentication;
import com.abiquo.apiclient.auth.TokenAuthentication;
import com.abiquo.server.core.enterprise.UserDto;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;

public class AuthenticationInterceptor
implements Interceptor {
    private Authentication authentication;
    private final RestClient client;

    public AuthenticationInterceptor(Authentication authentication, RestClient client) {
        this.authentication = (Authentication)Preconditions.checkNotNull((Object)authentication, (Object)"authentication cannot be null");
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"the same instance of client cannot be null");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String token;
        if (this.authentication.allowAbiquoToken() && BasicAuthentication.class.isInstance(this.authentication) && !chain.request().url().getPath().equals("/api/login")) {
            this.client.get("/login", "application/vnd.abiquo.user+json", UserDto.class);
        }
        Request authenticated = this.authentication.authenticate(chain.request());
        Response response = chain.proceed(authenticated);
        if (this.authentication.allowAbiquoToken() && (token = response.header("X-Abiquo-Token")) != null) {
            this.authentication = TokenAuthentication.token(token);
        }
        return response;
    }
}

