/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.api;

import com.abtasty.flagship.api.IFlagshipServiceEndpoints;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.net.MalformedURLException;
import java.net.URL;

public class FlagshipServiceEndpoints
implements IFlagshipServiceEndpoints {
    public static final String DEFAULT_DECISION_DOMAIN = "https://decision.flagship.io";
    public static final String DEFAULT_BUCKETING_DOMAIN = "https://cdn.flagship.io";
    public static final String DEFAULT_TRACKING_DOMAIN = "https://events.flagship.io";
    public static final String DEFAULT_CAMPAIGNS_ENDPOINT = "/v2/%s/campaigns?exposeAllKeys=true";
    public static final String DEFAULT_ACTIVATE_ENDPOINT = "/v2/activate";
    public static final String DEFAULT_EVENTS_ENDPOINT = "/v2/%s/events";
    public static final String DEFAULT_BUCKETING_ENDPOINT = "/%s/bucketing.json";
    public static final String CONTEXT_PARAM = "&sendContextEvent=false";
    protected String customCampaignEndpoint = "https://decision.flagship.io/v2/%s/campaigns?exposeAllKeys=true";
    protected String customActivateEndpoint = "https://decision.flagship.io/v2/activate";
    protected String customEventEndpoint = "https://decision.flagship.io/v2/%s/events";
    protected String customBucketingEndpoint = "https://cdn.flagship.io/%s/bucketing.json";
    protected String customTrackingEndpoint = "https://events.flagship.io";
    protected String envId = "_ENV_ID_";

    public final void init(String envId) {
        if (envId != null && !envId.isEmpty()) {
            this.envId = envId;
        }
        if (this.customCampaignEndpoint.equals("https://decision.flagship.io/v2/%s/campaigns?exposeAllKeys=true")) {
            this.customCampaignEndpoint = String.format(DEFAULT_CAMPAIGNS_ENDPOINT, envId);
        }
        if (this.customEventEndpoint.equals("https://decision.flagship.io/v2/%s/events")) {
            this.customEventEndpoint = String.format(DEFAULT_EVENTS_ENDPOINT, envId);
        }
        if (this.customBucketingEndpoint.equals("https://cdn.flagship.io/%s/bucketing.json")) {
            this.customBucketingEndpoint = String.format(DEFAULT_BUCKETING_ENDPOINT, envId);
        }
    }

    public final String getCampaignUrl(Boolean consent) {
        String customUrl = this.customCampaignEndpoint;
        if (!FlagshipServiceEndpoints.isUrlValid(customUrl).booleanValue()) {
            String fallbackUrl = String.format("https://decision.flagship.io/v2/%s/campaigns?exposeAllKeys=true", this.envId) + (consent == false ? CONTEXT_PARAM : "");
            FlagshipServiceEndpoints.logUrlInvalidError(customUrl, fallbackUrl);
            return fallbackUrl;
        }
        return customUrl;
    }

    public final String getActivateUrl() {
        String customUrl = this.customActivateEndpoint;
        if (!FlagshipServiceEndpoints.isUrlValid(customUrl).booleanValue()) {
            String fallbackUrl = "https://decision.flagship.io/v2/activate";
            FlagshipServiceEndpoints.logUrlInvalidError(customUrl, fallbackUrl);
            return fallbackUrl;
        }
        return customUrl;
    }

    public final String getEventUrl() {
        String customUrl = this.customEventEndpoint;
        if (!FlagshipServiceEndpoints.isUrlValid(customUrl).booleanValue()) {
            String fallbackUrl = "https://decision.flagship.io/v2/activate";
            FlagshipServiceEndpoints.logUrlInvalidError(customUrl, fallbackUrl);
            return fallbackUrl;
        }
        return customUrl;
    }

    public final String getBucketingUrl() {
        String customUrl = this.customBucketingEndpoint;
        if (!FlagshipServiceEndpoints.isUrlValid(customUrl).booleanValue()) {
            String fallbackUrl = "https://cdn.flagship.io/%s/bucketing.json";
            FlagshipServiceEndpoints.logUrlInvalidError(customUrl, fallbackUrl);
            return fallbackUrl;
        }
        return customUrl;
    }

    public final String getTrackingUrl() {
        String customUrl = this.customTrackingEndpoint;
        if (!FlagshipServiceEndpoints.isUrlValid(customUrl).booleanValue()) {
            String fallbackUrl = DEFAULT_TRACKING_DOMAIN;
            FlagshipServiceEndpoints.logUrlInvalidError(customUrl, fallbackUrl);
            return fallbackUrl;
        }
        return customUrl;
    }

    @Override
    public String overrideCampaignUrl(String url) {
        return url;
    }

    private static Boolean isUrlValid(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static void logUrlInvalidError(String url, String fallbackUrl) {
        FlagshipLogManager.log(FlagshipLogManager.Tag.INITIALIZATION, LogManager.Level.ERROR, String.format("The custom provided url '%s' has an invalid format. Default fallback domain '%s' will be used.", url, fallbackUrl));
    }

    public static class Builder {
        private final FlagshipServiceEndpoints customService = new FlagshipServiceEndpoints();

        public Builder withCampaignServiceUrl(String endpoint) {
            if (FlagshipServiceEndpoints.isUrlValid(endpoint).booleanValue()) {
                this.customService.customCampaignEndpoint = endpoint;
            }
            return this;
        }

        public Builder withActivateServiceUrl(String endpoint) {
            if (FlagshipServiceEndpoints.isUrlValid(endpoint).booleanValue()) {
                this.customService.customActivateEndpoint = endpoint;
            }
            return this;
        }

        public Builder withEventServiceUrl(String endpoint) {
            if (FlagshipServiceEndpoints.isUrlValid(endpoint).booleanValue()) {
                this.customService.customEventEndpoint = endpoint;
            }
            return this;
        }

        public Builder withBucketingServiceUrl(String endpoint) {
            if (FlagshipServiceEndpoints.isUrlValid(endpoint).booleanValue()) {
                this.customService.customBucketingEndpoint = endpoint;
            }
            return this;
        }

        public Builder withTrackingServiceUrl(String endpoint) {
            if (FlagshipServiceEndpoints.isUrlValid(endpoint).booleanValue()) {
                this.customService.customTrackingEndpoint = endpoint;
            }
            return this;
        }

        public FlagshipServiceEndpoints build() {
            return this.customService;
        }
    }
}

