/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.api;

import com.abtasty.flagship.BuildConfig;
import com.abtasty.flagship.api.FlagshipServiceEndpoints;
import com.abtasty.flagship.api.HttpManager;
import com.abtasty.flagship.api.IFlagshipEndpoints;
import com.abtasty.flagship.api.Response;
import com.abtasty.flagship.cache.HitCacheHelper;
import com.abtasty.flagship.hits.Activate;
import com.abtasty.flagship.hits.Hit;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class TrackingManager
implements IFlagshipEndpoints {
    private void sendActivation(VisitorDelegateDTO visitor, Activate hit) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-sdk-client", "java");
        headers.put("x-sdk-version", BuildConfig.flagship_version_name);
        JSONObject data = hit.getData();
        if (!visitor.getVisitorId().isEmpty() && visitor.getAnonymousId() != null) {
            data.put("aid", (Object)visitor.getAnonymousId());
            data.put("vid", (Object)visitor.getVisitorId());
        } else if (!visitor.getVisitorId().isEmpty() && visitor.getAnonymousId() == null) {
            data.put("vid", (Object)visitor.getVisitorId());
            data.put("aid", JSONObject.NULL);
        } else {
            data.put("vid", (Object)visitor.getAnonymousId());
            data.put("aid", JSONObject.NULL);
        }
        String url = Flagship.getConfig().getServiceEndpoints().getActivateUrl();
        this.sendTracking(visitor, "" + hit.getType(), url, headers, data, -1L);
    }

    public void sendHit(VisitorDelegateDTO visitor, Hit<?> hit) {
        if (hit instanceof Activate) {
            this.sendActivation(visitor, (Activate)hit);
        } else if (hit.checkData()) {
            JSONObject data = hit.getData();
            if (!visitor.getVisitorId().isEmpty() && visitor.getAnonymousId() != null) {
                data.put("cuid", (Object)visitor.getVisitorId());
                data.put("vid", (Object)visitor.getAnonymousId());
            } else if (!visitor.getVisitorId().isEmpty() && visitor.getAnonymousId() == null) {
                data.put("vid", (Object)visitor.getVisitorId());
                data.put("cuid", JSONObject.NULL);
            } else {
                data.put("vid", (Object)visitor.getAnonymousId());
                data.put("cuid", JSONObject.NULL);
            }
            String url = Flagship.getConfig().getServiceEndpoints().getTrackingUrl();
            this.sendTracking(visitor, "" + hit.getType(), url, null, data, -1L);
        } else {
            FlagshipLogManager.log(FlagshipLogManager.Tag.TRACKING, LogManager.Level.ERROR, String.format("'%s' hit invalid format error. \n %s", new Object[]{hit.getType(), hit}));
        }
    }

    public void sendHit(VisitorDelegateDTO visitorDelegateDTO, String type, long time, JSONObject content) {
        String endpoint = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        FlagshipServiceEndpoints endpoints = Flagship.getConfig().getServiceEndpoints();
        if (type.equals("CONTEXT")) {
            endpoint = endpoints.getEventUrl();
            headers.put("x-sdk-client", "android");
            headers.put("x-sdk-version", BuildConfig.flagship_version_name);
        } else if (type.equals("ACTIVATION")) {
            endpoint = endpoints.getActivateUrl();
            headers.put("x-sdk-client", "android");
            headers.put("x-sdk-version", BuildConfig.flagship_version_name);
        } else if (Arrays.asList("SCREENVIEW", "PAGEVIEW", "EVENT", "TRANSACTION", "ITEM", "CONSENT", "BATCH").contains(type)) {
            endpoint = endpoints.getTrackingUrl();
        }
        if (endpoint != null) {
            this.sendTracking(visitorDelegateDTO, type, endpoint, headers, content, time);
        }
    }

    private void sendTracking(VisitorDelegateDTO visitorDelegateDTO, String type, String endpoint, HashMap<String, String> headers, JSONObject content, long time) {
        HttpManager.getInstance().sendAsyncHttpRequest(HttpManager.RequestType.POST, endpoint, headers, content.toString()).whenComplete((response, error) -> {
            FlagshipLogManager.Tag tag;
            FlagshipLogManager.Tag tag2 = tag = type.equals(FlagshipLogManager.Tag.ACTIVATE.name()) ? FlagshipLogManager.Tag.ACTIVATE : FlagshipLogManager.Tag.TRACKING;
            if (response != null) {
                this.logHit(tag, (Response)response, response.getRequestContent());
            }
            if (response == null || response.getResponseCode() < 200 || response.getResponseCode() > 204) {
                JSONObject json = HitCacheHelper.fromHit(visitorDelegateDTO, type, content, time);
                visitorDelegateDTO.getVisitorDelegate().getStrategy().cacheHit(visitorDelegateDTO.getVisitorId(), json);
            }
        });
    }

    private void logHit(FlagshipLogManager.Tag tag, Response response, String content) {
        try {
            LogManager.Level level = response.getResponseCode() < 400 ? LogManager.Level.DEBUG : LogManager.Level.ERROR;
            String log = String.format("[%s] %s [%d] [%dms]\n%s", "POST", response.getRequestUrl(), response.getResponseCode(), response.getResponseTime(), new JSONObject(content).toString(3));
            FlagshipLogManager.log(tag, level, log);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendContextRequest(VisitorDelegateDTO visitor) {
        try {
            String endpoint = Flagship.getConfig().getServiceEndpoints().getEventUrl();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-sdk-client", "android");
            headers.put("x-sdk-version", BuildConfig.flagship_version_name);
            JSONObject data = new JSONObject();
            for (Map.Entry<String, Object> item : visitor.getContext().entrySet()) {
                data.put(item.getKey(), item.getValue());
            }
            JSONObject body = new JSONObject().put("visitorId", (Object)visitor.getVisitorId()).put("type", (Object)"CONTEXT").put("data", (Object)data);
            this.sendTracking(visitor, "CONTEXT", endpoint, headers, body, -1L);
        }
        catch (Exception e) {
            FlagshipLogManager.exception(e);
        }
    }
}

