/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.cache;

import com.abtasty.flagship.cache.CacheHelper;
import com.abtasty.flagship.model.Modification;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import com.abtasty.flagship.visitor.VisitorDelegate;
import com.abtasty.flagship.visitor.VisitorDelegateDTO;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class VisitorCacheHelper
extends CacheHelper {
    public static final int _VISITOR_CACHE_VERSION_ = 1;

    public static JSONObject visitorToCacheJSON(VisitorDelegateDTO visitorDelegateDTO) {
        JSONObject data = new JSONObject().put("visitorId", (Object)visitorDelegateDTO.getVisitorId()).put("anonymousId", (Object)visitorDelegateDTO.getAnonymousId()).put("consent", visitorDelegateDTO.hasConsented()).put("context", (Object)visitorDelegateDTO.contextToJson()).put("campaigns", (Object)VisitorCacheHelper.modificationsToCacheJSON(visitorDelegateDTO)).put("assignmentsHistory", (Object)VisitorCacheHelper.assignationHistoryToCacheJSON(visitorDelegateDTO));
        return new JSONObject().put("version", 1).put("data", (Object)data);
    }

    private static JSONArray modificationsToCacheJSON(VisitorDelegateDTO visitorDelegateDTO) {
        JSONArray campaigns = new JSONArray();
        for (Map.Entry<String, Modification> m : visitorDelegateDTO.getModifications().entrySet()) {
            boolean isCampaignSet = false;
            for (int i = 0; i < campaigns.length(); ++i) {
                JSONObject campaign = campaigns.getJSONObject(i);
                if (!Objects.equals(campaign.optString("campaignId"), m.getValue().getCampaignId()) || !Objects.equals(campaign.optString("variationGroupId"), m.getValue().getVariationGroupId()) || !Objects.equals(campaign.optString("variationId"), m.getValue().getVariationId())) continue;
                isCampaignSet = true;
                campaign.getJSONObject("flags").put(m.getValue().getKey(), m.getValue().getValue() != null ? m.getValue().getValue() : JSONObject.NULL);
            }
            if (isCampaignSet) continue;
            campaigns.put((Object)new JSONObject().put("campaignId", (Object)m.getValue().getCampaignId()).put("variationGroupId", (Object)m.getValue().getVariationGroupId()).put("variationId", (Object)m.getValue().getVariationId()).put("isReference", m.getValue().isReference()).put("type", (Object)m.getValue().getType()).put("slug", (Object)m.getValue().getSlug()).put("activated", visitorDelegateDTO.getActivatedVariations().contains(m.getValue().getVariationId())).put("flags", (Object)new JSONObject().put(m.getValue().getKey(), m.getValue().getValue() != null ? m.getValue().getValue() : JSONObject.NULL)));
        }
        return campaigns;
    }

    private static JSONObject assignationHistoryToCacheJSON(VisitorDelegateDTO visitorDelegateDTO) {
        JSONObject assignationsJSON = new JSONObject();
        for (Map.Entry<String, String> e : visitorDelegateDTO.getAssignmentsHistory().entrySet()) {
            assignationsJSON.put(e.getKey(), (Object)e.getValue());
        }
        return assignationsJSON;
    }

    public static void applyCacheToVisitor(VisitorDelegateDTO visitorDelegateDTO, JSONObject data) {
        int version = 0;
        try {
            if (data.keys().hasNext()) {
                version = data.getInt("version");
                VisitorMigrations.values()[version - 1].applyFromJSON(visitorDelegateDTO, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FlagshipLogManager.log(FlagshipLogManager.Tag.CACHE, LogManager.Level.ERROR, String.format("Error: '%s' have loaded a bad format version (%d) for visitor '%s'.", "lookupVisitor", version, visitorDelegateDTO.getVisitorId()));
        }
    }

    static enum VisitorMigrations implements CacheVisitorMigrationInterface
    {
        MIGRATION_1{

            @Override
            public void applyFromJSON(VisitorDelegateDTO visitorDelegateDTO, JSONObject data) {
                JSONObject dataObject = data.getJSONObject("data");
                VisitorDelegate visitorDelegate = visitorDelegateDTO.getVisitorDelegate();
                if (dataObject.getString("visitorId").equals(visitorDelegate.getVisitorId())) {
                    JSONObject assignmentsObject;
                    JSONArray campaignsArray;
                    visitorDelegate.setVisitorId(dataObject.optString("visitorId"));
                    visitorDelegate.setAnonymousId(dataObject.optString("anonymousId", null));
                    visitorDelegate.setConsent(dataObject.optBoolean("consent", true));
                    JSONObject jsonContext = data.optJSONObject("context");
                    if (jsonContext != null) {
                        jsonContext.keySet().forEach(key -> visitorDelegate.getContext().put((String)key, jsonContext.get(key)));
                    }
                    if ((campaignsArray = dataObject.optJSONArray("campaigns")) != null) {
                        for (int i = 0; i < campaignsArray.length(); ++i) {
                            JSONObject flagsJson;
                            JSONObject campaignObject = campaignsArray.getJSONObject(i);
                            String campaignId = campaignObject.getString("campaignId");
                            String variationGroupId = campaignObject.getString("variationGroupId");
                            String variationId = campaignObject.getString("variationId");
                            String slug = campaignObject.optString("slug", "");
                            boolean isReference = campaignObject.getBoolean("isReference");
                            String type = campaignObject.getString("type");
                            if (campaignObject.optBoolean("activated", false) && !visitorDelegate.getActivatedVariations().contains(variationId)) {
                                visitorDelegate.getActivatedVariations().add(variationId);
                            }
                            if ((flagsJson = campaignObject.optJSONObject("flags")) == null) continue;
                            flagsJson.keySet().forEach(key -> {
                                Modification modification = new Modification((String)key, campaignId, variationGroupId, variationId, isReference, flagsJson.get(key), type, slug);
                                visitorDelegate.getModifications().put((String)key, modification);
                            });
                        }
                    }
                    if ((assignmentsObject = dataObject.optJSONObject("assignmentsHistory")) != null) {
                        for (String key2 : assignmentsObject.keySet()) {
                            visitorDelegate.getAssignmentsHistory().put(key2, assignmentsObject.getString(key2));
                        }
                    }
                }
            }
        };

    }

    static interface CacheVisitorMigrationInterface {
        public void applyFromJSON(VisitorDelegateDTO var1, JSONObject var2);
    }
}

