/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.main;

import com.abtasty.flagship.api.FlagshipServiceEndpoints;
import com.abtasty.flagship.cache.CacheManager;
import com.abtasty.flagship.main.Flagship;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.util.concurrent.TimeUnit;

public abstract class FlagshipConfig<T> {
    private String envId = null;
    private String apiKey = null;
    private Flagship.DecisionMode decisionMode = Flagship.DecisionMode.API;
    private int timeout = 2000;
    private LogManager.Level logLevel = LogManager.Level.ALL;
    private LogManager logManager = new FlagshipLogManager(this.logLevel);
    private long pollingTime = 60L;
    private TimeUnit pollingUnit = TimeUnit.SECONDS;
    private Flagship.StatusListener statusListener = null;
    private CacheManager cacheManager = null;
    private FlagshipServiceEndpoints serviceEndpoints = new FlagshipServiceEndpoints();

    public FlagshipConfig() {
    }

    protected FlagshipConfig(String envId, String apiKey) {
        this.envId = envId;
        this.apiKey = apiKey;
    }

    protected void withEnvId(String envId) {
        this.envId = envId;
    }

    protected void withApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected T withDecisionMode(Flagship.DecisionMode mode) {
        if (mode != null) {
            this.decisionMode = mode;
        }
        return (T)this;
    }

    public T withLogManager(LogManager logManager) {
        this.logManager = logManager;
        return (T)this;
    }

    public T withLogLevel(LogManager.Level level) {
        if (level != null && this.logManager != null) {
            this.logLevel = level;
            this.logManager.setLevel(this.logLevel);
        }
        return (T)this;
    }

    public T withTimeout(int timeout) {
        if (timeout > 0) {
            this.timeout = timeout;
        }
        return (T)this;
    }

    protected T withBucketingPollingIntervals(long time, TimeUnit timeUnit) {
        if (time >= 0L && timeUnit != null && timeUnit != TimeUnit.MICROSECONDS && timeUnit != TimeUnit.NANOSECONDS) {
            this.pollingTime = time;
            this.pollingUnit = timeUnit;
        }
        return (T)this;
    }

    public T withStatusListener(Flagship.StatusListener listener) {
        if (listener != null) {
            this.statusListener = listener;
        }
        return (T)this;
    }

    public T withCacheManager(CacheManager customCacheManager) {
        this.cacheManager = customCacheManager;
        return (T)this;
    }

    public T withCustomServiceEndpoints(FlagshipServiceEndpoints customServiceEndpoints) {
        this.serviceEndpoints = customServiceEndpoints;
        return (T)this;
    }

    public Flagship.StatusListener getStatusListener() {
        return this.statusListener;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getEnvId() {
        return this.envId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Flagship.DecisionMode getDecisionMode() {
        return this.decisionMode;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public long getPollingTime() {
        return this.pollingTime;
    }

    public TimeUnit getPollingUnit() {
        return this.pollingUnit;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public FlagshipServiceEndpoints getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public String toString() {
        return "FlagshipConfig{envId='" + this.envId + "', apiKey='" + this.apiKey + "', mode=" + this.decisionMode + ", logManager=" + this.logManager + "}";
    }

    protected boolean isSet() {
        return this.envId != null && this.apiKey != null;
    }

    public static class DecisionApi
    extends FlagshipConfig<DecisionApi> {
        public DecisionApi() {
            super.withDecisionMode(Flagship.DecisionMode.API);
        }

        public DecisionApi(String envId, String apiKey) {
            super(envId, apiKey);
            super.withDecisionMode(Flagship.DecisionMode.API);
        }
    }

    public static class Bucketing
    extends FlagshipConfig<Bucketing> {
        public Bucketing() {
            super.withDecisionMode(Flagship.DecisionMode.BUCKETING);
        }

        public Bucketing(String envId, String apiKey) {
            super(envId, apiKey);
            super.withDecisionMode(Flagship.DecisionMode.BUCKETING);
        }

        public Bucketing withPollingIntervals(long time, TimeUnit timeUnit) {
            return (Bucketing)super.withBucketingPollingIntervals(time, timeUnit);
        }
    }
}

