/*
 * Decompiled with CFR 0.152.
 */
package com.abtasty.flagship.model;

import com.abtasty.flagship.model.VariationGroup;
import com.abtasty.flagship.utils.FlagshipLogManager;
import com.abtasty.flagship.utils.LogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Campaign
implements Serializable {
    private final String id;
    private final LinkedList<VariationGroup> variationGroups;

    public Campaign(String id, LinkedList<VariationGroup> variationGroups) {
        this.id = id;
        this.variationGroups = variationGroups;
    }

    public String getId() {
        return this.id;
    }

    public LinkedList<VariationGroup> getVariationGroups() {
        return this.variationGroups;
    }

    public static ArrayList<Campaign> parse(JSONArray campaignsArray) {
        try {
            ArrayList<Campaign> campaigns = new ArrayList<Campaign>();
            campaignsArray.forEach(campaignObject -> {
                Campaign campaign = Campaign.parse((JSONObject)campaignObject);
                if (campaign != null) {
                    campaigns.add(campaign);
                }
            });
            return campaigns;
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  campaign.");
            return null;
        }
    }

    public static Campaign parse(JSONObject campaignObject) {
        try {
            String id = campaignObject.getString("id");
            String campaignType = campaignObject.optString("type", "");
            String slug = campaignObject.isNull("slug") ? "" : campaignObject.optString("slug", "");
            LinkedList<VariationGroup> variationGroups = new LinkedList<VariationGroup>();
            JSONArray variationGroupArray = campaignObject.optJSONArray("variationGroups");
            if (variationGroupArray != null) {
                variationGroupArray.forEach(variationGroupsObj -> {
                    VariationGroup variationGroup = VariationGroup.parse(id, campaignType, slug, (JSONObject)variationGroupsObj, true);
                    if (variationGroup != null) {
                        variationGroups.add(variationGroup);
                    }
                });
            } else {
                VariationGroup variationGroup = VariationGroup.parse(id, campaignType, slug, campaignObject, false);
                if (variationGroup != null) {
                    variationGroups.add(variationGroup);
                }
            }
            return new Campaign(id, variationGroups);
        }
        catch (Exception e) {
            FlagshipLogManager.log(FlagshipLogManager.Tag.PARSING, LogManager.Level.ERROR, "an error occurred while parsing  campaign.");
            return null;
        }
    }

    public String toString() {
        return "Campaign{id='" + this.id + "', variationGroups=" + this.variationGroups + "}";
    }
}

